/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.flv;

import com.flazr.util.ValueToEnum;

public class VideoTag {
    private final FrameType frameType;
    private final CodecType codecType;

    public VideoTag(byte byteValue) {
        this.frameType = FrameType.valueToEnum(byteValue >> 4);
        this.codecType = CodecType.valueToEnum(0xF & byteValue);
    }

    public boolean isKeyFrame() {
        return this.frameType == FrameType.KEY;
    }

    public FrameType getFrameType() {
        return this.frameType;
    }

    public CodecType getCodecType() {
        return this.codecType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[frameType: ").append(this.frameType);
        sb.append(", codecType: ").append(this.codecType);
        sb.append(']');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CodecType implements ValueToEnum.IntValue
    {
        JPEG(1),
        H263(2),
        SCREEN(3),
        ON2VP6(4),
        ON2VP6_ALPHA(5),
        SCREEN_V2(6),
        AVC(7);

        private final int value;
        private static final ValueToEnum<CodecType> converter;

        private CodecType(int value) {
            this.value = value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        public static CodecType valueToEnum(int value) {
            return converter.valueToEnum(value);
        }

        static {
            converter = new ValueToEnum((Enum[])CodecType.values());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FrameType implements ValueToEnum.IntValue
    {
        KEY(1),
        INTER(2),
        DISPOSABLE_INTER(3),
        GENERATED_KEY(4),
        COMMAND(5);

        private final int value;
        private static final ValueToEnum<FrameType> converter;

        private FrameType(int value) {
            this.value = value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        public static FrameType valueToEnum(int value) {
            return converter.valueToEnum(value);
        }

        static {
            converter = new ValueToEnum((Enum[])FrameType.values());
        }
    }
}

