/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.flv;

import org.jboss.netty.buffer.ChannelBuffer;

public class H263Packet {
    private final int width;
    private final int height;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public H263Packet(ChannelBuffer in, int offset) {
        short bitPos24to39 = in.getShort(offset + 3);
        int pictureSize = 7 & bitPos24to39 >> 7;
        switch (pictureSize) {
            case 0: {
                short bitPos32to47 = in.getShort(offset + 4);
                this.width = 0x7F & bitPos32to47 >> 7;
                short bitPos40to55 = in.getShort(offset + 5);
                this.height = 0x7F & bitPos40to55 >> 7;
                break;
            }
            case 1: {
                int bitPos32to55 = in.getMedium(offset + 4);
                this.width = Short.MAX_VALUE & bitPos32to55 >> 7;
                int bitPos49to72 = in.getMedium(offset + 6);
                this.height = Short.MAX_VALUE & bitPos49to72 >> 7;
                break;
            }
            case 2: {
                this.width = 352;
                this.height = 288;
                break;
            }
            case 3: {
                this.width = 176;
                this.height = 144;
                break;
            }
            case 4: {
                this.width = 128;
                this.height = 96;
                break;
            }
            case 5: {
                this.width = 320;
                this.height = 240;
                break;
            }
            case 6: {
                this.width = 160;
                this.height = 120;
                break;
            }
            default: {
                throw new RuntimeException("unsupported size marker: " + pictureSize);
            }
        }
    }

    public String toString() {
        return "[width: " + this.width + ", height: " + this.height + "]";
    }
}

