/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.flv;

import com.flazr.io.flv.FlvAtom;
import com.flazr.rtmp.RtmpHeader;
import com.flazr.rtmp.RtmpMessage;
import com.flazr.rtmp.RtmpWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;
import org.jboss.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlvWriter
implements RtmpWriter {
    private static final Logger logger = LoggerFactory.getLogger(FlvWriter.class);
    private final FileChannel out;
    private final int[] channelTimes = new int[65600];
    private int primaryChannel = -1;
    private int lastLoggedSeconds;
    private final int seekTime;
    private final long startTime;

    public FlvWriter(String fileName) {
        this(0, fileName);
    }

    public FlvWriter(int seekTime, String fileName) {
        this.seekTime = seekTime < 0 ? 0 : seekTime;
        this.startTime = System.currentTimeMillis();
        if (fileName == null) {
            logger.info("save file notspecified, will only consume stream");
            this.out = null;
            return;
        }
        try {
            File file = new File(fileName);
            FileOutputStream fos = new FileOutputStream(file);
            this.out = fos.getChannel();
            this.out.write(FlvAtom.flvHeader().toByteBuffer());
            logger.info("opened file for writing: {}", (Object)file.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.primaryChannel == -1) {
            logger.warn("no media was written, closed file");
            return;
        }
        logger.info("finished in {} seconds, media duration: {} seconds (seek time: {})", new Object[]{(System.currentTimeMillis() - this.startTime) / 1000L, (this.channelTimes[this.primaryChannel] - this.seekTime) / 1000, this.seekTime / 1000});
    }

    private void logWriteProgress() {
        int seconds = (this.channelTimes[this.primaryChannel] - this.seekTime) / 1000;
        if (seconds >= this.lastLoggedSeconds + 10) {
            logger.info("write progress: " + seconds + " seconds");
            this.lastLoggedSeconds = seconds - seconds % 10;
        }
    }

    public void write(RtmpMessage message) {
        RtmpHeader header = message.getHeader();
        if (header.isAggregate()) {
            ChannelBuffer in = message.encode();
            while (in.readable()) {
                int absoluteTime;
                FlvAtom flvAtom = new FlvAtom(in);
                this.channelTimes[this.primaryChannel] = absoluteTime = flvAtom.getHeader().getTime();
                this.write(flvAtom);
                this.logWriteProgress();
            }
        } else {
            int channelId = header.getChannelId();
            this.channelTimes[channelId] = this.seekTime + header.getTime();
            if (this.primaryChannel == -1 && (header.isAudio() || header.isVideo())) {
                logger.info("first media packet for channel: {}", (Object)header);
                this.primaryChannel = channelId;
            }
            if (header.getSize() <= 2) {
                return;
            }
            this.write(new FlvAtom(header.getMessageType(), this.channelTimes[channelId], message.encode()));
            if (channelId == this.primaryChannel) {
                this.logWriteProgress();
            }
        }
    }

    private void write(FlvAtom flvAtom) {
        if (logger.isDebugEnabled()) {
            logger.debug("writing: {}", (Object)flvAtom);
        }
        if (this.out == null) {
            return;
        }
        try {
            this.out.write(flvAtom.write().toByteBuffer());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

