/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.flv;

import com.flazr.io.BufferReader;
import com.flazr.io.FileChannelReader;
import com.flazr.io.flv.FlvAtom;
import com.flazr.rtmp.RtmpMessage;
import com.flazr.rtmp.RtmpReader;
import com.flazr.rtmp.message.Aggregate;
import com.flazr.rtmp.message.MessageType;
import com.flazr.rtmp.message.Metadata;
import com.flazr.rtmp.message.MetadataAmf0;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlvReader
implements RtmpReader {
    private static final Logger logger = LoggerFactory.getLogger(FlvReader.class);
    private final BufferReader in;
    private final long mediaStartPosition;
    private final Metadata metadata;
    private int aggregateDuration;
    private static final int AGGREGATE_SIZE_LIMIT = 65536;

    public FlvReader(String path) {
        this.in = new FileChannelReader(path);
        this.in.position(13L);
        RtmpMessage metadataAtom = this.next();
        RtmpMessage metadataTemp = MessageType.decode(metadataAtom.getHeader(), metadataAtom.encode());
        if (metadataTemp.getHeader().isMetadata()) {
            this.metadata = (Metadata)metadataTemp;
            this.mediaStartPosition = this.in.position();
        } else {
            logger.warn("flv file does not start with 'onMetaData', using empty one");
            this.metadata = new MetadataAmf0("onMetaData", new Object[0]);
            this.in.position(13L);
            this.mediaStartPosition = 13L;
        }
        logger.debug("flv file metadata: {}", (Object)this.metadata);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public RtmpMessage[] getStartMessages() {
        return new RtmpMessage[]{this.metadata};
    }

    public void setAggregateDuration(int targetDuration) {
        this.aggregateDuration = targetDuration;
    }

    public long getTimePosition() {
        int time;
        if (this.hasNext()) {
            time = this.next().getHeader().getTime();
            this.prev();
        } else if (this.hasPrev()) {
            time = this.prev().getHeader().getTime();
            this.next();
        } else {
            throw new RuntimeException("not seekable");
        }
        return time;
    }

    private static boolean isSyncFrame(RtmpMessage message) {
        byte firstByte = message.encode().getByte(0);
        return (firstByte & 0xF0) == 16;
    }

    public long seek(long time) {
        RtmpMessage cursor;
        logger.debug("trying to seek to: {}", (Object)time);
        if (time == 0L) {
            try {
                this.in.position(this.mediaStartPosition);
                return 0L;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        long start = this.getTimePosition();
        if (time > start) {
            while (this.hasNext() && (long)(cursor = this.next()).getHeader().getTime() < time) {
            }
        } else {
            while (this.hasPrev()) {
                cursor = this.prev();
                if ((long)cursor.getHeader().getTime() > time) continue;
                this.next();
                break;
            }
        }
        try {
            long checkPoint = this.in.position();
            while (this.hasPrev()) {
                RtmpMessage cursor2 = this.prev();
                if (!cursor2.getHeader().isVideo() || !FlvReader.isSyncFrame(cursor2)) continue;
                logger.debug("returned seek frame / position: {}", (Object)cursor2);
                return cursor2.getHeader().getTime();
            }
            this.in.position(checkPoint);
            return this.getTimePosition();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasNext() {
        return this.in.position() < this.in.size();
    }

    protected boolean hasPrev() {
        return this.in.position() > this.mediaStartPosition;
    }

    protected RtmpMessage prev() {
        long oldPos = this.in.position();
        this.in.position(oldPos - 4L);
        long newPos = oldPos - 4L - (long)this.in.readInt();
        this.in.position(newPos);
        FlvAtom flvAtom = new FlvAtom(this.in);
        this.in.position(newPos);
        return flvAtom;
    }

    public RtmpMessage next() {
        if (this.aggregateDuration <= 0) {
            return new FlvAtom(this.in);
        }
        ChannelBuffer out = ChannelBuffers.dynamicBuffer();
        int firstAtomTime = -1;
        while (this.hasNext()) {
            FlvAtom flvAtom = new FlvAtom(this.in);
            int currentAtomTime = flvAtom.getHeader().getTime();
            if (firstAtomTime == -1) {
                firstAtomTime = currentAtomTime;
            }
            ChannelBuffer temp = flvAtom.write();
            if (out.readableBytes() + temp.readableBytes() > 65536) {
                this.prev();
                break;
            }
            out.writeBytes(temp);
            if (currentAtomTime - firstAtomTime <= this.aggregateDuration) continue;
            break;
        }
        return new Aggregate(firstAtomTime, out);
    }

    public void close() {
        this.in.close();
    }

    public static void main(String[] args) {
        FlvReader reader = new FlvReader("home/apps/vod/IronMan.flv");
        while (reader.hasNext()) {
            RtmpMessage message = reader.next();
            logger.debug("{} {}", (Object)message, (Object)ChannelBuffers.hexDump((ChannelBuffer)message.encode()));
        }
        reader.close();
    }
}

