/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.f4v.box;

import com.flazr.io.f4v.Payload;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STCO
implements Payload {
    private static final Logger logger = LoggerFactory.getLogger(STCO.class);
    private final boolean co64;
    private List<Long> offsets;

    public STCO(ChannelBuffer in) {
        this(in, false);
    }

    public STCO(ChannelBuffer in, boolean co64) {
        this.co64 = co64;
        this.read(in);
    }

    public void setOffsets(List<Long> offsets) {
        this.offsets = offsets;
    }

    public List<Long> getOffsets() {
        return this.offsets;
    }

    @Override
    public void read(ChannelBuffer in) {
        in.readInt();
        int count = in.readInt();
        logger.debug("no of chunk offsets: {}", (Object)count);
        this.offsets = new ArrayList<Long>(count);
        for (int i = 0; i < count; ++i) {
            Long offset = this.co64 ? in.readLong() : (long)in.readInt();
            this.offsets.add(offset);
        }
    }

    @Override
    public ChannelBuffer write() {
        ChannelBuffer out = ChannelBuffers.dynamicBuffer();
        out.writeInt(0);
        out.writeInt(this.offsets.size());
        for (Long offset : this.offsets) {
            if (this.co64) {
                out.writeLong(offset.longValue());
                continue;
            }
            out.writeInt(offset.intValue());
        }
        return out;
    }
}

