/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.f4v;

import com.flazr.io.f4v.Box;
import com.flazr.io.f4v.Chunk;
import com.flazr.io.f4v.MovieInfo;
import com.flazr.io.f4v.Payload;
import com.flazr.io.f4v.Sample;
import com.flazr.io.f4v.box.CTTS;
import com.flazr.io.f4v.box.MDHD;
import com.flazr.io.f4v.box.STCO;
import com.flazr.io.f4v.box.STSC;
import com.flazr.io.f4v.box.STSD;
import com.flazr.io.f4v.box.STSS;
import com.flazr.io.f4v.box.STSZ;
import com.flazr.io.f4v.box.STTS;
import com.flazr.io.f4v.box.TKHD;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackInfo {
    private static final Logger logger = LoggerFactory.getLogger(TrackInfo.class);
    private MovieInfo movie;
    private TKHD tkhd;
    private MDHD mdhd;
    private STSD stsd;
    private STTS stts;
    private CTTS ctts;
    private STSC stsc;
    private STSZ stsz;
    private STCO stco;
    private STSS stss;
    private List<Chunk> chunks;

    public TrackInfo(Box trak) {
        ArrayList<Box> collect = new ArrayList<Box>();
        Box.recurse(trak, collect, 0);
        for (Box box : collect) {
            logger.debug("unpacking: {}", (Object)box);
            Payload pay = box.getPayload();
            switch (box.getType()) {
                case TKHD: {
                    this.tkhd = (TKHD)pay;
                    break;
                }
                case MDHD: {
                    this.mdhd = (MDHD)pay;
                    break;
                }
                case STSD: {
                    this.stsd = (STSD)pay;
                    break;
                }
                case STTS: {
                    this.stts = (STTS)pay;
                    break;
                }
                case CTTS: {
                    this.ctts = (CTTS)pay;
                    break;
                }
                case STSC: {
                    this.stsc = (STSC)pay;
                    break;
                }
                case STSZ: {
                    this.stsz = (STSZ)pay;
                    break;
                }
                case STCO: {
                    this.stco = (STCO)pay;
                    break;
                }
                case STSS: {
                    this.stss = (STSS)pay;
                }
            }
        }
        this.initChunks();
        logger.debug("initialized track info table");
    }

    public MDHD getMdhd() {
        return this.mdhd;
    }

    public STSD getStsd() {
        return this.stsd;
    }

    public MovieInfo getMovie() {
        return this.movie;
    }

    public void setMovie(MovieInfo movie) {
        this.movie = movie;
    }

    public List<Chunk> getChunks() {
        return this.chunks;
    }

    private void initChunks() {
        Sample sample;
        Chunk chunk;
        int stcoIndex = 0;
        int stszIndex = 0;
        this.chunks = new ArrayList<Chunk>();
        int stscCount = this.stsc.getRecords().size();
        HashSet<Integer> syncSampleNumbers = null;
        if (this.stss != null) {
            syncSampleNumbers = new HashSet<Integer>(this.stss.getSampleNumbers());
        }
        for (int i = 0; i < stscCount; ++i) {
            STSC.STSCRecord stscRecord = this.stsc.getRecords().get(i);
            int lastChunkWithSameSize = i + 1 == stscCount ? (i == 0 ? this.stco.getOffsets().size() : stscRecord.getFirstChunk()) : this.stsc.getRecords().get(i + 1).getFirstChunk() - 1;
            for (int j = stcoIndex; j < lastChunkWithSameSize; ++j) {
                chunk = new Chunk();
                int sampleFileOffset = 0;
                chunk.setSampleDescIndex(stscRecord.getSampleDescIndex());
                chunk.setFileOffset(this.stco.getOffsets().get(stcoIndex++));
                for (int k = 0; k < stscRecord.getSamplesPerChunk(); ++k) {
                    Sample sample2 = new Sample();
                    sample2.setSize(this.stsz.getSampleSizes().get(stszIndex++));
                    sample2.setFileOffset(chunk.getFileOffset() + (long)sampleFileOffset);
                    sampleFileOffset += sample2.getSize();
                    if (syncSampleNumbers != null && syncSampleNumbers.contains(stszIndex)) {
                        sample2.setSyncSample(true);
                    }
                    chunk.add(sample2);
                }
                chunk.setTrack(this);
                this.chunks.add(chunk);
            }
        }
        int chunkIndex = 0;
        int sampleIndex = 0;
        long rawTime = 0L;
        chunk = this.chunks.get(chunkIndex);
        block3: for (STTS.STTSRecord sttsRecord : this.stts.getRecords()) {
            for (int i = 0; i < sttsRecord.getSampleCount(); ++i) {
                if (sampleIndex == chunk.getSampleCount()) {
                    if (++chunkIndex == this.chunks.size()) break block3;
                    chunk = this.chunks.get(chunkIndex);
                    sampleIndex = 0;
                }
                sample = chunk.getSamples().get(sampleIndex++);
                int rawDuration = sttsRecord.getSampleDuration();
                int duration = sample.convertFromTimeScale(rawDuration);
                sample.setDuration(duration);
                int time = sample.convertFromTimeScale(rawTime);
                sample.setTime(time);
                rawTime += (long)rawDuration;
            }
        }
        if (this.ctts == null) {
            return;
        }
        chunkIndex = 0;
        sampleIndex = 0;
        chunk = this.chunks.get(chunkIndex);
        block5: for (CTTS.CTTSRecord cttsRecord : this.ctts.getRecords()) {
            for (int i = 0; i < cttsRecord.getSampleCount(); ++i) {
                if (sampleIndex == chunk.getSampleCount()) {
                    if (++chunkIndex == this.chunks.size()) break block5;
                    chunk = this.chunks.get(chunkIndex);
                    sampleIndex = 0;
                }
                sample = chunk.getSamples().get(sampleIndex++);
                int compositionTimeOffset = sample.convertFromTimeScale(cttsRecord.getSampleOffset());
                sample.setCompositionTimeOffset(compositionTimeOffset);
            }
        }
    }
}

