/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io;

import com.flazr.io.BufferReader;
import java.io.File;
import java.io.RandomAccessFile;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomAccessFileReader
implements BufferReader {
    private static final Logger logger = LoggerFactory.getLogger(RandomAccessFileReader.class);
    private final String absolutePath;
    private final RandomAccessFile in;
    private final long fileSize;

    public RandomAccessFileReader(String path) {
        this(new File(path));
    }

    public RandomAccessFileReader(File file) {
        this.absolutePath = file.getAbsolutePath();
        try {
            this.in = new RandomAccessFile(file, "r");
            this.fileSize = this.in.length();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long size() {
        return this.fileSize;
    }

    public long position() {
        try {
            return this.in.getFilePointer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void position(long position) {
        try {
            this.in.seek(position);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ChannelBuffer read(int size) {
        return ChannelBuffers.wrappedBuffer((byte[])this.readBytes(size));
    }

    public byte[] readBytes(int size) {
        byte[] bytes = new byte[size];
        try {
            this.in.readFully(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return bytes;
    }

    public int readInt() {
        return this.read(4).readInt();
    }

    public long readUnsignedInt() {
        return this.read(4).readUnsignedInt();
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (Exception e) {
            logger.warn("error closing file {}: {}", (Object)this.absolutePath, (Object)e.getMessage());
        }
        logger.info("closed file: {}", (Object)this.absolutePath);
    }
}

