/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io;

import com.flazr.io.BufferReader;
import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChannelReader
implements BufferReader {
    private static final Logger logger = LoggerFactory.getLogger(FileChannelReader.class);
    private final String absolutePath;
    private final FileChannel in;
    private final long fileSize;

    public FileChannelReader(String path) {
        this(new File(path));
    }

    public FileChannelReader(File file) {
        this.absolutePath = file.getAbsolutePath();
        try {
            this.in = new FileInputStream(file).getChannel();
            this.fileSize = this.in.size();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        logger.info("opened file: {}", (Object)this.absolutePath);
    }

    public long size() {
        return this.fileSize;
    }

    public long position() {
        try {
            return this.in.position();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void position(long newPosition) {
        try {
            this.in.position(newPosition);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ChannelBuffer read(int size) {
        return ChannelBuffers.wrappedBuffer((byte[])this.readBytes(size));
    }

    public int readInt() {
        return this.read(4).readInt();
    }

    public long readUnsignedInt() {
        return this.read(4).readUnsignedInt();
    }

    public byte[] readBytes(int size) {
        byte[] bytes = new byte[size];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        try {
            this.in.read(bb);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return bytes;
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (Exception e) {
            logger.warn("error closing file {}: {}", (Object)this.absolutePath, (Object)e.getMessage());
        }
        logger.info("closed file: {}", (Object)this.absolutePath);
    }
}

