/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcontrols.dialog;

import info.magnolia.cms.beans.runtime.Document;
import info.magnolia.cms.beans.runtime.MultipartForm;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.core.NodeData;
import info.magnolia.cms.core.Path;
import info.magnolia.cms.gui.fckeditor.FCKEditorTmpFiles;
import info.magnolia.cms.security.AccessDeniedException;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.context.MgnlContext;
import info.magnolia.module.admininterface.FieldSaveHandler;
import info.magnolia.module.admininterface.SaveHandlerImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialogGridSaveHandler
implements FieldSaveHandler {
    private static Logger log = LoggerFactory.getLogger(DialogGridSaveHandler.class);

    public void save(Content parentNode, Content configNode, String name, MultipartForm form, int type, int valueType, int isRichEditValue, int encoding) throws RepositoryException, AccessDeniedException {
        ArrayList colConfigs = new ArrayList();
        if (configNode != null && configNode.hasContent("columns")) {
            colConfigs.addAll(configNode.getContent("columns").getChildren(ItemType.CONTENTNODE));
        }
        HierarchyManager hm = parentNode.getHierarchyManager();
        Content filesNode = ContentUtil.getOrCreateContent((Content)parentNode, (String)(name + "_files"), (ItemType)ItemType.CONTENTNODE);
        String value = form.getParameter(name);
        String ctx = MgnlContext.getContextPath();
        String tmpPath = "/tmp/fckeditor/";
        ArrayList<String> usedFiles = new ArrayList<String>();
        StringBuffer sbValue = new StringBuffer(value.length());
        StringBuffer sbLine = new StringBuffer();
        for (String line : StringUtils.splitPreserveAllTokens((String)value, (char)'\n')) {
            line = StringUtils.removeEnd((String)line, (String)"\r");
            int colIndex = 0;
            for (String token : StringUtils.splitPreserveAllTokens((String)line, (char)'\t')) {
                if (colIndex < colConfigs.size()) {
                    Content node;
                    Content colConfig = (Content)colConfigs.get(colIndex);
                    String colType = NodeDataUtil.getString((Content)colConfig, (String)"type");
                    if ("uuidLink".equals(colType)) {
                        String repository = StringUtils.defaultIfEmpty((String)NodeDataUtil.getString((Content)colConfig, (String)"repository"), (String)"website");
                        node = ContentUtil.getContent((String)repository, (String)token);
                        if (node != null) {
                            token = node.getUUID();
                        }
                    } else if ("media".equals(colType)) {
                        String mediaValueType = StringUtils.defaultIfEmpty((String)NodeDataUtil.getString((Content)colConfig, (String)"valueType"), (String)"uuid");
                        if ("uuid".equals(mediaValueType) && (node = ContentUtil.getContent((String)"media", (String)token)) != null) {
                            token = node.getUUID();
                        }
                    } else if ("file".equals(colType)) {
                        String link;
                        if (token.startsWith(ctx) && StringUtils.startsWith((String)(link = StringUtils.substringAfter((String)token, (String)ctx)), (String)tmpPath)) {
                            String uuid = StringUtils.substringBetween((String)link, (String)tmpPath, (String)"/");
                            Document doc = FCKEditorTmpFiles.getDocument((String)uuid);
                            String fileNodeName = Path.getUniqueLabel((HierarchyManager)hm, (String)filesNode.getHandle(), (String)"file");
                            SaveHandlerImpl.saveDocument((Content)filesNode, (Document)doc, (String)fileNodeName, (String)"", (String)"");
                            token = link = filesNode.getHandle() + "/" + fileNodeName + "/" + doc.getFileNameWithExtension();
                            doc.delete();
                            try {
                                FileUtils.deleteDirectory((File)new File(Path.getTempDirectory() + "/fckeditor/" + uuid));
                            }
                            catch (IOException e) {
                                log.error("can't delete tmp file [" + Path.getTempDirectory() + "/fckeditor/" + uuid + "]");
                            }
                        }
                        if (token.startsWith(filesNode.getHandle())) {
                            String fileNodeName = StringUtils.removeStart((String)token, (String)(filesNode.getHandle() + "/"));
                            fileNodeName = StringUtils.substringBefore((String)fileNodeName, (String)"/");
                            usedFiles.add(fileNodeName);
                        }
                    }
                }
                if (colIndex > 0) {
                    sbLine.append('\t');
                }
                sbLine.append(token);
                ++colIndex;
            }
            if (sbValue.length() > 0) {
                sbValue.append('\n');
            }
            sbValue.append(sbLine);
            sbLine.setLength(0);
        }
        for (NodeData fileNodeData : filesNode.getNodeDataCollection()) {
            if (usedFiles.contains(fileNodeData.getName())) continue;
            fileNodeData.delete();
        }
        NodeDataUtil.getOrCreateAndSet((Content)parentNode, (String)name, (Object)new String(sbValue));
    }
}

