/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcontrols.dialog;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.cms.util.NodeDataUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.openutils.mgnlcontrols.dialog.ConfigurableFreemarkerDialog;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogGrid
extends ConfigurableFreemarkerDialog {
    private List<Content> colConfigs = new ArrayList<Content>();

    @Override
    public void init(HttpServletRequest request, HttpServletResponse response, Content websiteNode, Content configNode) throws RepositoryException {
        super.init(request, response, websiteNode, configNode);
        if (StringUtils.isEmpty((String)this.getConfigValue("saveHandler"))) {
            this.setConfig("saveHandler", "net.sourceforge.openutils.mgnlcontrols.dialog.DialogGridSaveHandler");
        }
        if (configNode != null && configNode.hasContent("columns")) {
            this.colConfigs.addAll(configNode.getContent("columns").getChildren(ItemType.CONTENTNODE));
        }
    }

    @Override
    protected String getPath() {
        return "dialogs/grid.ftl";
    }

    @Override
    protected void addToParameters(Map<String, Object> parameters) {
        super.addToParameters(parameters);
        String value = this.getValue();
        if (value != null) {
            StringBuffer sbValue = new StringBuffer(value.length());
            StringBuffer sbLine = new StringBuffer();
            for (String line : StringUtils.splitPreserveAllTokens((String)value, (char)'\n')) {
                line = StringUtils.removeEnd((String)line, (String)"\r");
                int colIndex = 0;
                for (String token : StringUtils.splitPreserveAllTokens((String)line, (char)'\t')) {
                    if (colIndex < this.colConfigs.size()) {
                        String valueType;
                        Content node;
                        Content colConfig = this.colConfigs.get(colIndex);
                        String colType = NodeDataUtil.getString((Content)colConfig, (String)"type");
                        if ("uuidLink".equals(colType)) {
                            String repository = StringUtils.defaultIfEmpty((String)NodeDataUtil.getString((Content)colConfig, (String)"repository"), (String)"website");
                            node = ContentUtil.getContentByUUID((String)repository, (String)token);
                            if (node != null) {
                                token = node.getHandle();
                            }
                        } else if ("media".equals(colType) && "uuid".equals(valueType = StringUtils.defaultIfEmpty((String)NodeDataUtil.getString((Content)colConfig, (String)"valueType"), (String)"uuid")) && (node = ContentUtil.getContentByUUID((String)"media", (String)token)) != null) {
                            token = node.getHandle();
                        }
                    }
                    if (colIndex > 0) {
                        sbLine.append('\t');
                    }
                    sbLine.append(token);
                    ++colIndex;
                }
                if (sbValue.length() > 0) {
                    sbValue.append('\n');
                }
                sbValue.append(sbLine);
                sbLine.setLength(0);
            }
            value = new String(sbValue);
        }
        parameters.put("gridValue", value);
    }
}

