/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import org.apache.jackrabbit.core.query.lucene.ChildAxisQuery;
import org.apache.jackrabbit.core.query.lucene.DescendantSelfAxisQuery;
import org.apache.jackrabbit.core.query.lucene.JackrabbitTermQuery;
import org.apache.jackrabbit.core.query.lucene.NameQuery;
import org.apache.jackrabbit.core.query.lucene.NotQuery;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class QueryDecoratorSupport {
    protected final SearchIndex index;

    public QueryDecoratorSupport(SearchIndex index) {
        this.index = index;
    }

    protected Query nameQuery(String n) {
        return new NameQuery(NameFactoryImpl.getInstance().create("", n), this.index.getIndexFormatVersion(), this.index.getNamespaceMappings());
    }

    protected Query jackrabbitTermQuery(String f) {
        return new JackrabbitTermQuery(new Term(f));
    }

    protected Query booleanQuery(Query ... qs) {
        return this.booleanQuery(qs, (BooleanClause.Occur[])null);
    }

    protected Query booleanQuery(Query[] qs, BooleanClause.Occur[] os) {
        BooleanQuery bq = new BooleanQuery();
        for (int i = 0; i < qs.length; ++i) {
            BooleanClause.Occur o = os != null && i < os.length ? os[i] : BooleanClause.Occur.MUST;
            bq.add(qs[i], o);
        }
        return bq;
    }

    protected Query childAxisQuery(Query q, String n) {
        return new ChildAxisQuery(this.index.getContext().getItemStateManager(), q, NameFactoryImpl.getInstance().create("", n), this.index.getIndexFormatVersion(), this.index.getNamespaceMappings());
    }

    protected Query descendantSelfAxisQuery(Query cq, Query sq) {
        return new DescendantSelfAxisQuery(cq, sq, 1);
    }

    protected Query notQuery(Query cq) {
        return new NotQuery(cq);
    }
}

