/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcriteria.utils;

import java.lang.reflect.InvocationTargetException;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import javax.jcr.query.Row;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JcrCompatUtils {
    private static Logger log = LoggerFactory.getLogger(JcrCompatUtils.class);

    private JcrCompatUtils() {
    }

    public static Item getJCRNode(Row row) throws RepositoryException {
        try {
            return (Item)PropertyUtils.getProperty((Object)row, (String)"node");
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            log.warn("Error extracting node from row: {}", (Object)(e.getTargetException() != null ? e.getTargetException().getClass().getName() + " " + e.getTargetException().getMessage() : e.getMessage()));
        }
        catch (NoSuchMethodException e) {
            log.error("Unsupported version of jackrabbit detected, you need at least 1.6.x or a jcr 2.0 compliant version");
        }
        return null;
    }
}

