/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcriteria.utils;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public abstract class BaseAnalyzer
extends Analyzer {
    public TokenStream tokenStream(String fieldName, Reader reader) {
        StandardTokenizer tokenStream = this.tokenize(reader);
        return this.tokenFiltersChain((TokenStream)tokenStream);
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            this.setPreviousTokenStream(streams);
            streams.tokenStream = this.tokenize(reader);
            streams.filteredTokenStream = this.tokenFiltersChain((TokenStream)streams.tokenStream);
        } else {
            streams.tokenStream.reset(reader);
        }
        return streams.filteredTokenStream;
    }

    protected StandardTokenizer tokenize(Reader reader) {
        return new StandardTokenizer(reader);
    }

    protected abstract TokenStream tokenFiltersChain(TokenStream var1);

    private static final class SavedStreams {
        StandardTokenizer tokenStream;
        TokenStream filteredTokenStream;

        private SavedStreams() {
        }
    }
}

