/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcriteria.jcr.query.lucene;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import javax.jcr.RepositoryException;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sourceforge.openutils.mgnlcriteria.advanced.impl.QueryExecutorHelper;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.lucene.AclQueryDecorator;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.lucene.LuceneQueryBuilder;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.query.DefaultQueryNodeFactory;
import org.apache.jackrabbit.spi.commons.query.QueryNodeVisitor;
import org.apache.jackrabbit.spi.commons.query.QueryRootNode;
import org.apache.lucene.search.Query;

public class AclSearchIndex
extends SearchIndex {
    private DefaultQueryNodeFactory proxiedQueryNodeFactory;

    public AclSearchIndex() {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(DefaultQueryNodeFactory.class);
        enhancer.setCallback((Callback)new AclMethodInterceptor());
        this.proxiedQueryNodeFactory = (DefaultQueryNodeFactory)enhancer.create((Class[])DefaultQueryNodeFactory.class.getConstructors()[0].getParameterTypes(), new Object[]{Collections.unmodifiableList(Arrays.asList(NameConstants.NT_CHILDNODEDEFINITION, NameConstants.NT_FROZENNODE, NameConstants.NT_NODETYPE, NameConstants.NT_PROPERTYDEFINITION, NameConstants.NT_VERSION, NameConstants.NT_VERSIONEDCHILD, NameConstants.NT_VERSIONHISTORY, NameConstants.NT_VERSIONLABELS, NameConstants.REP_NODETYPES, NameConstants.REP_SYSTEM, NameConstants.REP_VERSIONSTORAGE, NameConstants.NT_BASE, NameConstants.MIX_REFERENCEABLE))});
    }

    protected DefaultQueryNodeFactory getQueryNodeFactory() {
        return this.proxiedQueryNodeFactory;
    }

    class AclMethodInterceptor
    implements MethodInterceptor {
        AclMethodInterceptor() {
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            String name = method.getName();
            if ("createQueryRootNode".equals(name)) {
                return new QueryRootNode(){

                    public Object accept(QueryNodeVisitor visitor, Object data) throws RepositoryException {
                        Query luceneQuery = (Query)super.accept(visitor, data);
                        if (!QueryExecutorHelper.isExecuting()) {
                            return luceneQuery;
                        }
                        try {
                            Field sessionField = LuceneQueryBuilder.class.getDeclaredField("session");
                            sessionField.setAccessible(true);
                            SessionImpl session = (SessionImpl)sessionField.get(visitor);
                            AclQueryDecorator decorator = new AclQueryDecorator(session, AclSearchIndex.this);
                            return decorator.applyAcl(luceneQuery);
                        }
                        catch (Throwable e) {
                            throw new RepositoryException(e);
                        }
                    }
                };
            }
            return proxy.invokeSuper(obj, args);
        }
    }
}

