/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcriteria.jcr.query.lucene;

import info.magnolia.cms.security.AccessManager;
import info.magnolia.cms.security.Permission;
import info.magnolia.cms.util.SimpleUrlPattern;
import info.magnolia.context.MgnlContext;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.lucene.MatchAllDocsQuery;
import org.apache.jackrabbit.core.query.lucene.QueryDecoratorSupport;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;

public class AclQueryDecorator
extends QueryDecoratorSupport {
    private final SessionImpl session;

    public AclQueryDecorator(SessionImpl session, SearchIndex index) {
        super(index);
        this.session = session;
    }

    public Query applyAcl(Query query) throws RepositoryException {
        ArrayList<MyPermission> permissionPatterns = new ArrayList<MyPermission>();
        AccessManager accessManager = MgnlContext.getAccessManager((String)this.session.getWorkspace().getName());
        List permissions = accessManager.getPermissionList();
        if (!permissions.isEmpty()) {
            try {
                Field patternStringField = SimpleUrlPattern.class.getDeclaredField("patternString");
                patternStringField.setAccessible(true);
                for (Permission permission : permissions) {
                    String pattern;
                    String[] tokens;
                    if (!(permission.getPattern() instanceof SimpleUrlPattern) || (tokens = StringUtils.splitPreserveAllTokens((String)(pattern = (String)patternStringField.get(permission.getPattern())), (char)'/')).length <= 2 || !"".equals(tokens[0]) || !"*".equals(tokens[tokens.length - 1])) continue;
                    String basePath = StringUtils.removeEnd((String)pattern, (String)"/*");
                    boolean deny = (permission.getPermissions() & 8L) == 0L;
                    permissionPatterns.add(new MyPermission(basePath, deny));
                }
            }
            catch (NoSuchFieldException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        Collections.sort(permissionPatterns, new Comparator<MyPermission>(){

            @Override
            public int compare(MyPermission o1, MyPermission o2) {
                return o1.getBasePath().length() - o2.getBasePath().length();
            }
        });
        HashMap map = new HashMap();
        for (MyPermission item : permissionPatterns) {
            String prefix = item.getBasePath();
            while (prefix.length() > 0) {
                if (map.containsKey(prefix)) {
                    ((List)map.get(prefix)).add(item);
                }
                prefix = StringUtils.substringBeforeLast((String)prefix, (String)"/");
            }
            ArrayList<MyPermission> list = new ArrayList<MyPermission>();
            list.add(item);
            map.put(item.getBasePath(), list);
        }
        Query[] qs = new Query[1 + map.size()];
        int i = 0;
        qs[i++] = query;
        for (List list : map.values()) {
            MyPermission[] items = list.toArray(new MyPermission[0]);
            qs[i++] = !((MyPermission)list.get(0)).isDeny() ? this.allowQuery(items) : this.denyQuery(items);
        }
        return this.booleanQuery(qs);
    }

    private Query allowQuery(MyPermission[] items) {
        Query[] qs = new Query[items.length];
        BooleanClause.Occur[] os = new BooleanClause.Occur[items.length];
        for (int i = 0; i < items.length; ++i) {
            qs[i] = this.query(items[i]);
            os[i] = !items[i].isDeny() ? BooleanClause.Occur.MUST : BooleanClause.Occur.MUST_NOT;
        }
        return this.booleanQuery(qs, os);
    }

    private Query denyQuery(MyPermission[] items) {
        Query[] qs = new Query[items.length];
        BooleanClause.Occur[] os = new BooleanClause.Occur[items.length];
        for (int i = 0; i < items.length; ++i) {
            qs[i] = !items[i].isDeny() ? this.query(items[i]) : this.notQuery(this.query(items[i]));
            os[i] = BooleanClause.Occur.SHOULD;
        }
        return this.booleanQuery(qs, os);
    }

    private Query query(MyPermission item) {
        String[] tokens = StringUtils.splitPreserveAllTokens((String)item.getBasePath(), (char)'/');
        Query q = null;
        for (int j = 1; j < tokens.length; ++j) {
            q = q == null ? this.descendantSelfAxisQuery(this.jackrabbitTermQuery("_:PARENT"), this.nameQuery(tokens[j])) : this.childAxisQuery(q, tokens[j]);
        }
        return this.descendantSelfAxisQuery(this.booleanQuery(q), (Query)new MatchAllDocsQuery());
    }

    private static class MyPermission {
        private final String basePath;
        private final boolean deny;

        public MyPermission(String basePath, boolean deny) {
            this.basePath = basePath;
            this.deny = deny;
        }

        public String getBasePath() {
            return this.basePath;
        }

        public boolean isDeny() {
            return this.deny;
        }
    }
}

