/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.Criteria;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.JCRQueryException;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Criterion;
import org.apache.commons.lang.StringUtils;

public class Junction
implements Criterion {
    private static final long serialVersionUID = 4745761472724863693L;
    private final List<Criterion> criteria = new ArrayList<Criterion>();
    private final String op;

    protected Junction(String op) {
        this.op = op;
    }

    public Junction add(Criterion criterion) {
        this.criteria.add(criterion);
        return this;
    }

    public String getOp() {
        return this.op;
    }

    public String toXPathString(Criteria crit) throws JCRQueryException {
        if (this.criteria.size() == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder().append('(');
        Iterator<Criterion> iter = this.criteria.iterator();
        boolean isfirst = true;
        while (iter.hasNext()) {
            String xPathString = iter.next().toXPathString(crit);
            if (!StringUtils.isNotBlank((String)xPathString)) continue;
            if (!isfirst && StringUtils.isNotBlank((String)xPathString)) {
                buffer.append(' ').append(this.op).append(" ");
            }
            buffer.append(xPathString);
            isfirst = false;
        }
        return buffer.append(')').toString();
    }

    public String toString() {
        return '(' + StringUtils.join(this.criteria.iterator(), (String)(' ' + this.op + ' ')) + ')';
    }

    public boolean isEmpty() {
        return this.criteria.isEmpty();
    }
}

