/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcriteria.advanced.impl;

import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.security.AccessDeniedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import net.sourceforge.openutils.mgnlcriteria.advanced.impl.MappedDefaultContent;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.AdvancedResultItem;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedResultItemImpl
extends MappedDefaultContent
implements AdvancedResultItem {
    private final Row row;
    private static Logger log = LoggerFactory.getLogger(AdvancedResultItemImpl.class);

    public AdvancedResultItemImpl(Row row, Item item, HierarchyManager hierarchyManager) throws RepositoryException, AccessDeniedException {
        super(item, hierarchyManager);
        this.row = row;
    }

    public String getExcerpt() {
        return this.getExcerpt(".");
    }

    public String getExcerpt(String selector) {
        Value excerptValue;
        try {
            excerptValue = this.row.getValue("rep:excerpt(" + selector + ")");
        }
        catch (RepositoryException e) {
            log.warn("Error getting excerpt for " + this.getHandle(), (Throwable)e);
            return null;
        }
        if (excerptValue != null) {
            try {
                return excerptValue.getString();
            }
            catch (RepositoryException e) {
                log.warn("Error getting excerpt for " + this.getHandle(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public double getScore() {
        try {
            return (Double)PropertyUtils.getSimpleProperty((Object)this.row, (String)"score");
        }
        catch (IllegalAccessException e) {
            log.warn("Error getting score for {}", (Object)this.getHandle(), (Object)e);
        }
        catch (InvocationTargetException e) {
            log.warn("Error getting score for {}", (Object)this.getHandle(), (Object)e);
        }
        catch (NoSuchMethodException e) {
            log.error("Unsupported version of jackrabbit detected, you need at least 1.6.x or a jcr 2.0 compliant version");
        }
        return 0.0;
    }

    public double getScore(String selector) {
        Method jcrRowGetScore = null;
        try {
            jcrRowGetScore = this.row.getClass().getDeclaredMethod("getScore", String.class);
            jcrRowGetScore.setAccessible(true);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (jcrRowGetScore != null) {
            try {
                if (selector == null) {
                    return (Double)PropertyUtils.getSimpleProperty((Object)this.row, (String)"score");
                }
                return (Double)jcrRowGetScore.invoke((Object)this.row, selector);
            }
            catch (IllegalArgumentException e) {
                log.warn("Error getting score for " + this.getHandle(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.warn("Error getting score for " + this.getHandle(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.warn("Error getting score for " + this.getHandle(), e.getTargetException());
            }
            catch (NoSuchMethodException e) {
                log.warn("Error getting score for " + this.getHandle(), (Throwable)e);
            }
        } else {
            log.error("Unsupported version of jackrabbit detected, you need at least 1.6.x or a jcr 2.0 compliant version");
        }
        return 0.0;
    }
}

