/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcriteria.advanced.impl;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.content2bean.Content2BeanException;
import info.magnolia.content2bean.Content2BeanUtil;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import net.sourceforge.openutils.mgnlcriteria.advanced.impl.AccessibleResultItemResultIterator;
import net.sourceforge.openutils.mgnlcriteria.advanced.impl.AdvancedResultItemImpl;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.AdvancedResult;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.AdvancedResultItem;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.JCRQueryException;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.ResultIterator;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.ResultIteratorImpl;
import net.sourceforge.openutils.mgnlcriteria.utils.JcrCompatUtils;
import org.apache.jackrabbit.core.query.lucene.QueryResultImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedResultImpl
implements AdvancedResult {
    private final QueryResultImpl jcrQueryResult;
    private final int itemsPerPage;
    private final int pageNumberStartingFromOne;
    private final String statement;
    private HierarchyManager hm;
    private String spellCheckerSuggestion;
    private final Query spellCheckerQuery;
    private Logger log = LoggerFactory.getLogger(AdvancedResultImpl.class);
    private final boolean applyLocalPaging;

    public AdvancedResultImpl(QueryResultImpl jcrQueryResult, int itemsPerPage, int pageNumberStartingFromOne, String statement, HierarchyManager hm, Query spellCheckerQuery) {
        this(jcrQueryResult, itemsPerPage, pageNumberStartingFromOne, statement, hm, spellCheckerQuery, false);
    }

    public AdvancedResultImpl(QueryResultImpl jcrQueryResult, int itemsPerPage, int pageNumberStartingFromOne, String statement, HierarchyManager hm, Query spellCheckerQuery, boolean applyLocalPaging) {
        this.jcrQueryResult = jcrQueryResult;
        this.itemsPerPage = itemsPerPage;
        this.statement = statement;
        this.hm = hm;
        this.spellCheckerQuery = spellCheckerQuery;
        this.pageNumberStartingFromOne = pageNumberStartingFromOne;
        this.applyLocalPaging = applyLocalPaging;
    }

    @Override
    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    @Override
    public int getPage() {
        return this.pageNumberStartingFromOne;
    }

    @Override
    public int getTotalSize() {
        if (this.jcrQueryResult.getTotalSize() == -1 && (this.itemsPerPage == 0 || this.applyLocalPaging)) {
            try {
                return (int)this.jcrQueryResult.getNodes().getSize();
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return this.jcrQueryResult.getTotalSize();
    }

    @Override
    public int getNumberOfPages() {
        return this.itemsPerPage > 0 ? (int)Math.round(Math.ceil((float)this.jcrQueryResult.getTotalSize() / (float)this.itemsPerPage)) : 1;
    }

    @Override
    public ResultIterator<AdvancedResultItem> getItems() {
        RowIterator rows;
        try {
            rows = this.jcrQueryResult.getRows();
        }
        catch (RepositoryException e) {
            JCRQueryException jqe = new JCRQueryException(this.statement, e);
            throw jqe;
        }
        if (this.applyLocalPaging && this.itemsPerPage > 0) {
            final int offset = (Math.max(this.pageNumberStartingFromOne, 1) - 1) * this.itemsPerPage;
            rows.skip((long)offset);
            return new AccessibleResultItemResultIterator(rows, this.hm){

                public boolean hasNext() {
                    return super.getPosition() - (long)offset < Math.min(super.getSize() - (long)offset, (long)AdvancedResultImpl.this.itemsPerPage) && super.hasNext();
                }

                public long getSize() {
                    return Math.min(super.getSize() - (long)offset, (long)AdvancedResultImpl.this.itemsPerPage);
                }
            };
        }
        return new AccessibleResultItemResultIterator(rows, this.hm);
    }

    @Override
    public String getSpellCheckerSuggestion() {
        if (this.spellCheckerSuggestion == null && this.spellCheckerQuery != null) {
            try {
                RowIterator rows = this.spellCheckerQuery.execute().getRows();
                Row r = rows.nextRow();
                Value v = r.getValue("rep:spellcheck()");
                if (v != null) {
                    this.spellCheckerSuggestion = v.getString();
                }
            }
            catch (InvalidQueryException e) {
                this.log.warn("Error getting excerpt using " + this.spellCheckerQuery.getStatement(), (Throwable)e);
                return null;
            }
            catch (RepositoryException e) {
                this.log.warn("Error getting excerpt using " + this.spellCheckerQuery.getStatement(), (Throwable)e);
                return null;
            }
        }
        return this.spellCheckerSuggestion;
    }

    @Override
    public AdvancedResultItem getFirstResult() {
        ResultIterator<AdvancedResultItem> items = this.getItems();
        if (items.hasNext()) {
            return items.next();
        }
        return null;
    }

    @Override
    public <K> ResultIterator<K> getItems(final Class<K> theclass) {
        RowIterator rows;
        try {
            rows = this.jcrQueryResult.getRows();
        }
        catch (RepositoryException e) {
            throw new JCRQueryException(this.statement, e);
        }
        return new ResultIteratorImpl<K>(rows, this.hm){

            @Override
            protected K wrap(Row row) {
                try {
                    Item jcrNode = JcrCompatUtils.getJCRNode(row);
                    if (jcrNode == null) {
                        return null;
                    }
                    return Content2BeanUtil.toBean((Content)new AdvancedResultItemImpl(row, jcrNode, this.hm), (boolean)true, (Class)theclass);
                }
                catch (RepositoryException e) {
                    throw new RuntimeException(e);
                }
                catch (Content2BeanException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

