/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcriteria.jcr.query.xpath.utils;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XPathTextUtils {
    private static Logger log = LoggerFactory.getLogger(XPathTextUtils.class);

    private XPathTextUtils() {
    }

    public static String stringToXPathLiteral(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        return str.replaceAll("'", "\"");
    }

    public static String stringToJCRSearchExp(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        String parseString = StringUtils.trimToEmpty((String)str);
        parseString = StringUtils.replaceEach((String)parseString, (String[])new String[]{":)", ":("}, (String[])new String[]{": )", ": ("});
        String escapeChars = "[\\\\+\\-\\!\\(\\)\\:\\^\\]\\{\\}\\~\\*\\?\"\\[\\]|]";
        parseString = parseString.replaceAll(escapeChars, "\\\\$0");
        if (StringUtils.startsWith((String)(parseString = parseString.replaceAll("'", "''")), (String)"OR ")) {
            parseString = parseString.replaceFirst("\\bOR\\b", "\"OR\"");
        }
        return parseString;
    }

    public static String encodeDigitsInPath(String path) {
        log.debug("path to encode is {}", (Object)path);
        if (StringUtils.isBlank((String)path)) {
            String msg = "path cannot be a null or empty string";
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        StringBuilder encodedPath = new StringBuilder(path.length());
        for (int i = 0; i < path.length(); ++i) {
            char ch = path.charAt(i);
            if (i > 0 && path.charAt(i - 1) == '/' && Character.isDigit(ch)) {
                encodedPath.append("_x" + StringUtils.leftPad((String)Integer.toHexString(ch), (int)4, (char)'0') + "_");
                continue;
            }
            encodedPath.append(ch);
        }
        log.debug("returning encoded path {}", (Object)encodedPath);
        return encodedPath.toString();
    }
}

