/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcriteria.jcr.query.xpath;

import net.sourceforge.openutils.mgnlcriteria.jcr.query.Criteria;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.JCRQueryException;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.TranslatableCriteria;
import org.apache.commons.lang.StringUtils;

public class JCRMagnoliaCriteriaQueryTranslator {
    private final TranslatableCriteria criteria;

    public JCRMagnoliaCriteriaQueryTranslator(TranslatableCriteria criteria) throws JCRQueryException {
        this.criteria = criteria;
    }

    public Criteria getRootCriteria() {
        return this.criteria;
    }

    public String getPredicate() {
        StringBuilder condition = new StringBuilder(30);
        boolean isfirst = true;
        for (TranslatableCriteria.CriterionEntry entry : this.criteria.getCriterionEntries()) {
            String xpathString = entry.getCriterion().toXPathString(entry.getCriteria());
            if (!StringUtils.isNotBlank((String)xpathString)) continue;
            if (!isfirst && StringUtils.isNotBlank((String)xpathString)) {
                condition.append(" and ");
            }
            condition.append(xpathString);
            isfirst = false;
        }
        return condition.toString();
    }

    public String getOrderBy() {
        StringBuilder orderBy = new StringBuilder(30);
        for (TranslatableCriteria.OrderEntry oe : this.criteria.getOrderEntries()) {
            if (orderBy.length() > 0) {
                orderBy.append(", ");
            }
            orderBy.append(oe.getOrder().toXPathString(oe.getCriteria()));
        }
        return orderBy.toString();
    }
}

