/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.Criteria;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.JCRQueryException;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.BaseCriterion;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Criterion;
import org.apache.commons.lang.StringUtils;

public class SimpleExpression
extends BaseCriterion
implements Criterion {
    private static final long serialVersionUID = -1104419394978535803L;
    private final String propertyName;
    private final Object value;
    private final String op;

    protected SimpleExpression(String propertyName, Object value, String op) {
        this.propertyName = propertyName;
        this.value = value;
        this.op = op;
    }

    public String toString() {
        return this.propertyName + this.getOp() + this.value;
    }

    protected final String getOp() {
        return this.op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXPathString(Criteria criteria) throws JCRQueryException {
        StringBuilder fragment = new StringBuilder();
        fragment.append(" (");
        if (this.value instanceof String) {
            fragment.append(this.propertyName).append(this.getOp());
            String escValue = StringUtils.replace((String)((String)this.value), (String)"'", (String)"''");
            fragment.append("'" + escValue + "') ");
        } else if (this.value instanceof Number) {
            fragment.append(this.propertyName).append(this.getOp());
            fragment.append(this.value + ") ");
        } else if (this.value instanceof Character) {
            fragment.append(this.propertyName).append(this.getOp());
            fragment.append("'" + Character.toString(((Character)this.value).charValue()) + "') ");
        } else if (this.value instanceof Boolean) {
            if (((Boolean)this.value).booleanValue()) {
                fragment.append(this.propertyName).append(this.getOp());
                fragment.append(this.value + ") ");
            } else {
                fragment.append("(");
                fragment.append(this.propertyName).append(this.getOp());
                fragment.append(this.value + ") or not(").append(this.propertyName + " ))");
            }
        } else if (this.value instanceof Calendar) {
            String fmt;
            fragment.append(this.propertyName).append(this.getOp());
            Calendar cal = (Calendar)this.value;
            SimpleDateFormat simpleDateFormat = DATE_FORMAT;
            synchronized (simpleDateFormat) {
                DATE_FORMAT.setCalendar(cal);
                fmt = DATE_FORMAT.format(cal.getTime());
            }
            fragment.append("xs:dateTime('" + fmt + "+00:00" + "')) ");
        } else if (this.value != null) {
            fragment.append(this.propertyName).append(this.getOp());
            fragment.append("'" + this.value + "') ");
        }
        this.log.debug("xpathString is {} ", (Object)fragment);
        return fragment.toString();
    }
}

