/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion;

import java.util.Calendar;
import java.util.Collection;
import java.util.TimeZone;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.BetweenExpression;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Conjunction;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Criterion;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Disjunction;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.InExpression;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.IsNotNullExpression;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.IsNullExpression;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.JCRFunctionExpression;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.LikeExpression;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.LogicalExpression;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.MatchMode;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.NotExpression;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.SimpleExpression;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.xpath.utils.XPathTextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Restrictions {
    private static final Calendar MIDNIGHT_GMT = Calendar.getInstance(TimeZone.getTimeZone("GMT"));

    private Restrictions() {
    }

    public static SimpleExpression eq(String nodeName, Object value) {
        return new SimpleExpression(nodeName, value, "=");
    }

    public static SimpleExpression ne(String nodeName, Object value) {
        return new SimpleExpression(nodeName, value, "!=");
    }

    public static JCRFunctionExpression like(String nodeName, Object value) {
        return new LikeExpression(nodeName, XPathTextUtils.stringToJCRSearchExp(value.toString()), " jcr:like", MatchMode.ANYWHERE);
    }

    public static JCRFunctionExpression like(String nodeName, Object value, MatchMode matchMode) {
        return new LikeExpression(nodeName, XPathTextUtils.stringToJCRSearchExp(value.toString()), " jcr:like", matchMode);
    }

    public static JCRFunctionExpression contains(String nodeName, Object value) {
        return Restrictions.contains(nodeName, value, true);
    }

    public static JCRFunctionExpression contains(String nodeName, Object value, boolean escape) {
        String exp = escape ? XPathTextUtils.stringToJCRSearchExp(value.toString()) : value.toString();
        return new JCRFunctionExpression(nodeName, exp, " jcr:contains");
    }

    public static SimpleExpression gt(String nodeName, Object value) {
        return new SimpleExpression(nodeName, value, ">");
    }

    public static SimpleExpression lt(String nodeName, Object value) {
        return new SimpleExpression(nodeName, value, "<");
    }

    public static SimpleExpression le(String nodeName, Object value) {
        return new SimpleExpression(nodeName, value, "<=");
    }

    public static SimpleExpression ge(String nodeName, Object value) {
        return new SimpleExpression(nodeName, value, ">=");
    }

    public static Criterion between(String nodeName, Object lo, Object hi) {
        return new BetweenExpression(nodeName, lo, hi);
    }

    public static Criterion eqDate(String nodeName, Calendar value) {
        return Restrictions.betweenDates(nodeName, value, value);
    }

    public static Criterion betweenDates(String nodeName, Calendar lo, Calendar hi) {
        return Restrictions.between(nodeName, Restrictions.getDayStart(lo), Restrictions.getDayEnd(hi));
    }

    public static Criterion in(String nodeName, String[] values) {
        return new InExpression(nodeName, values);
    }

    public static Criterion in(String nodeName, Collection<String> values) {
        return new InExpression(nodeName, values.toArray(new String[values.size()]));
    }

    public static Criterion isNull(String nodeName) {
        return new IsNullExpression(nodeName);
    }

    public static Criterion isNotNull(String nodeName) {
        return new IsNotNullExpression(nodeName);
    }

    public static LogicalExpression and(Criterion lhs, Criterion rhs) {
        return new LogicalExpression(lhs, rhs, "and");
    }

    public static LogicalExpression or(Criterion lhs, Criterion rhs) {
        return new LogicalExpression(lhs, rhs, "or");
    }

    public static Criterion not(Criterion expression) {
        return new NotExpression(expression);
    }

    public static Conjunction conjunction() {
        return new Conjunction();
    }

    public static Disjunction disjunction() {
        return new Disjunction();
    }

    private static Calendar getDayStart(Calendar cal) {
        Calendar cal2 = (Calendar)MIDNIGHT_GMT.clone();
        cal2.set(cal.get(1), cal.get(2), cal.get(5));
        return cal2;
    }

    private static Calendar getDayEnd(Calendar cal) {
        Calendar cal2 = Restrictions.getDayStart(cal);
        cal2.add(6, 1);
        cal2.add(14, -1);
        return cal2;
    }

    static {
        MIDNIGHT_GMT.set(11, 0);
        MIDNIGHT_GMT.set(12, 0);
        MIDNIGHT_GMT.set(13, 0);
        MIDNIGHT_GMT.set(14, 0);
    }
}

