/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion;

import net.sourceforge.openutils.mgnlcriteria.jcr.query.Criteria;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.JCRQueryException;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.JCRFunctionExpression;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.MatchMode;

public class LikeExpression
extends JCRFunctionExpression {
    private static final long serialVersionUID = 1810624472706401714L;
    private MatchMode matchMode;

    public LikeExpression(String propertyName, Object value, String function, MatchMode matchMode) {
        super(propertyName, value, function);
        if (matchMode == null) {
            throw new IllegalArgumentException("MatchMode can't be null");
        }
        this.matchMode = matchMode;
    }

    public String toXPathString(Criteria criteria) throws JCRQueryException {
        StringBuilder fragment = new StringBuilder();
        fragment.append(" (" + this.function + "(");
        fragment.append(this.propertyName);
        fragment.append(", '" + this.matchMode.toMatchString(this.value.toString()) + "') ) ");
        this.log.debug("xpathString is {} ", (Object)fragment);
        return fragment.toString();
    }
}

