/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.Criteria;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.JCRQueryException;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.BaseCriterion;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Criterion;

public class BetweenExpression
extends BaseCriterion
implements Criterion {
    private static final long serialVersionUID = 6686395240415024541L;
    private final String propertyName;
    private final Object lo;
    private final Object hi;

    protected BetweenExpression(String propertyName, Object lo, Object hi) {
        this.propertyName = propertyName;
        this.lo = lo;
        this.hi = hi;
    }

    public String toString() {
        return this.propertyName + " between " + this.lo + " and " + this.hi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXPathString(Criteria criteria) throws JCRQueryException {
        StringBuilder fragment = new StringBuilder();
        fragment.append(" (").append(this.propertyName).append(" >= ");
        if (this.lo instanceof String && this.hi instanceof String) {
            fragment.append("'" + this.lo + "' and " + this.propertyName + " <= '" + this.hi + "'");
        } else if (this.lo instanceof Number && this.hi instanceof Number) {
            fragment.append(this.lo + " and " + this.propertyName + " <= " + this.hi);
        } else if (this.lo instanceof Calendar && this.hi instanceof Calendar) {
            String fmt2;
            String fmt;
            Calendar cal = (Calendar)this.lo;
            Calendar cal2 = (Calendar)this.hi;
            SimpleDateFormat simpleDateFormat = DATE_FORMAT;
            synchronized (simpleDateFormat) {
                DATE_FORMAT.setCalendar(cal);
                fmt = DATE_FORMAT.format(cal.getTime());
                DATE_FORMAT.setCalendar(cal2);
                fmt2 = DATE_FORMAT.format(cal2.getTime());
            }
            fragment.append("xs:dateTime('" + fmt + "+00:00" + "')  and " + this.propertyName + " <= " + "xs:dateTime" + "('" + fmt2 + "+00:00" + "') ");
        } else {
            String msg = "values provided are not of the accepted types String, Number, Calendar";
            this.log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        fragment.append(")");
        this.log.debug("xpathString is {} ", (Object)fragment);
        return fragment.toString();
    }
}

