/**
 *
 * Magnolia Criteria API (http://www.openmindlab.com/lab/products/mgnlcriteria.html)
 * Copyright(C) 2009-2010, Openmind S.r.l. http://www.openmindonline.it
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.sourceforge.openutils.mgnlcriteria.advanced;

import info.magnolia.cms.beans.config.ContentRepository;
import info.magnolia.cms.core.Content;
import info.magnolia.context.MgnlContext;

import java.util.Collection;
import java.util.List;

import net.sourceforge.openutils.mgnlcriteria.jcr.query.AdvancedResult;
import net.sourceforge.openutils.mgnlcriteria.tests.CriteriaTestUtils;
import net.sourceforge.openutils.mgnlcriteria.tests.RepositoryTestNgTestcase;

import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;


/**
 * @author fgiust
 * @version $Id: ScoreAnalizerAndSortTest.java 2916 2010-08-28 09:20:10Z fgiust $
 */
public class ScoreAnalizerAndSortTest extends RepositoryTestNgTestcase
{

    /**
     * {@inheritDoc}
     */
    @Override
    @BeforeClass
    protected void setUp() throws Exception
    {
        setRepositoryConfigFileName("/crit-repository/test-repositories.xml");
        setJackrabbitRepositoryConfigFileName("/crit-repository/jackrabbit-test-configuration.xml");

        super.setUp();

        bootstrapSingleResource("/crit-bootstrap/website.00000.xml");
        MgnlContext.getHierarchyManager(ContentRepository.WEBSITE).save();
    }

    @Test
    public void testSearchDante() throws Exception
    {
        // Dante Alighieri
        // Alighieri, Dante

        AdvancedResult advResult = CriteriaTestUtils.search("Dante Alighieri", 1, 200);
        Collection< ? extends Content> result = CriteriaTestUtils.collectCollectionFromResult(advResult);

        CriteriaTestUtils.assertNumOfResults(2, result, "Dante Alighieri");
    }

    @Test
    public void testSearchFagiano() throws Exception
    {
        // fagiano
        // fagiàno
        // fàgiànò

        AdvancedResult advResult = CriteriaTestUtils.search("fagiano", 1, 200);
        Collection< ? extends Content> result = CriteriaTestUtils.collectCollectionFromResult(advResult);

        CriteriaTestUtils.assertNumOfResults(3, result, "fagiano");
    }

    @Test
    public void testSearchPesca() throws Exception
    {
        // pèsca
        // canna da pesca

        AdvancedResult advResult = CriteriaTestUtils.search("pesca", 1, 200);
        Collection< ? extends Content> result = CriteriaTestUtils.collectCollectionFromResult(advResult);

        CriteriaTestUtils.assertSortedResults(new String[]{"pèsca", "canna da pesca" }, result, "pesca");
    }

    @Test
    public void testSearchPageNumber1() throws Exception
    {
        AdvancedResult advResult = CriteriaTestUtils.search("francia", 1, 1);
        Assert.assertEquals(advResult.getPage(), 1);
    }

    // see CRIT-17
    @Test
    public void testSearchPageNumber2() throws Exception
    {
        AdvancedResult advResult = CriteriaTestUtils.search("francia", 2, 1);
        Assert.assertEquals(advResult.getPage(), 2);
    }

    @Test
    public void testSearchPageNumber3() throws Exception
    {
        AdvancedResult advResult = CriteriaTestUtils.search("francia", 3, 1);
        Assert.assertEquals(advResult.getPage(), 3);
    }

    @Test
    public void testSearchFrancia() throws Exception
    {
        // --- "francia" in titles:
        // Frància
        // Parigi (Francia)
        // Parigi (Frància)

        // --- "francia" in paragraphs:
        // "Tallart, Camille d'Hostun, cónte di-",
        // "federale",
        // ":)",
        // "Faccina sorridente :)"

        AdvancedResult advResult = CriteriaTestUtils.search("francia", 1, 200);
        Collection< ? extends Content> result = CriteriaTestUtils.collectCollectionFromResult(advResult);

        Assert.assertEquals(advResult.getTotalSize(), 7);

        // the correct result should be:
        // Frància
        // Parigi (Francia)
        // Parigi (Frància)

        // jackrabbit 1.6 return this order

        // jackrabbit 2.0 returns:
        // Parigi (Francia)
        // Parigi (Frància)
        // Frància
        // --> probably the score is evaluted differently with the custom analizer for "à" (or maybe it's a bug...
        // anyway just check the first three results ignoring the order

        CriteriaTestUtils.assertUnsortedResults(
            new String[]{"Frància", "Parigi (Francia)", "Parigi (Frància)", },
            ((List< ? extends Content>) result).subList(0, 3),
            "francia");

        // the remaining 4 pages have the same score, so the order is not stable (changes between jdk5 and jdk6)
        // "Tallart, Camille d'Hostun, cónte di-",
        // "federale",
        // ":)",
        // "Faccina sorridente :)"
    }

}
