/**
 *
 * Magnolia Criteria API (http://www.openmindlab.com/lab/products/mgnlcriteria.html)
 * Copyright(C) 2009-2010, Openmind S.r.l. http://www.openmindonline.it
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.sourceforge.openutils.mgnlcriteria.advanced;

import info.magnolia.cms.beans.config.ContentRepository;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.context.MgnlContext;

import javax.jcr.query.Query;

import net.sourceforge.openutils.mgnlcriteria.advanced.impl.AdvancedResultImpl;
import net.sourceforge.openutils.mgnlcriteria.advanced.impl.QueryExecutorHelper;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.JCRQueryException;
import net.sourceforge.openutils.mgnlcriteria.tests.RepositoryTestNgTestcase;

import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;


/**
 * Unit test on escaping quotation mark in jcr:contains(). Unescaped quotation marks are not illegal: no Exception is
 * thrown on query execution. All quotation marks (not only the trailing one) should be escaped to obatain results.
 * @author dschivo
 * @version $Id: JcrContainsQuestionMarkTest.java 2933 2010-08-29 16:00:21Z fgiust $
 */
public class JcrContainsQuestionMarkTest extends RepositoryTestNgTestcase
{

    /**
     * {@inheritDoc}
     */
    @Override
    @BeforeClass
    protected void setUp() throws Exception
    {
        setRepositoryConfigFileName("/crit-repository/test-repositories.xml");
        setJackrabbitRepositoryConfigFileName("/crit-repository/jackrabbit-test-configuration.xml");

        super.setUp();

        // Titles of the nodes in this workspace:
        // - hello test? world
        // - hello te?st world
        // - hello "Milano" world
        // - lorem
        // - lorem ipsum
        // - dolor sit
        // - dolor sit amet
        bootstrapSingleResource("/crit-bootstrap/website.contains.xml");
        MgnlContext.getHierarchyManager(ContentRepository.WEBSITE).save();
    }

    @SuppressWarnings("deprecation")
    @Test
    public void testTrailingUnescaped() throws Exception
    {
        HierarchyManager hm = MgnlContext.getHierarchyManager(ContentRepository.WEBSITE);

        AdvancedResultImpl advResult = null;
        try
        {
            String stmt = "//*[((@jcr:primaryType='mgnl:content') and (jcr:contains(@title,'test?')))] order by @jcr:score";
            advResult = QueryExecutorHelper.execute(stmt, Query.XPATH, hm, 10, 0, null);
        }
        catch (JCRQueryException e)
        {
            // The following statement is NOT true:
            // A search string like 'test?' will run into a ParseException documented in
            // http://issues.apache.org/jira/browse/JCR-1248
            Assert.fail("http://issues.apache.org/jira/browse/JCR-1248");
        }

        // remark: total size is only evaluated when the result is sorted
        Assert.assertEquals(advResult.getTotalSize(), 0);
    }

    @SuppressWarnings("deprecation")
    @Test
    public void testTrailingEscaped() throws Exception
    {
        HierarchyManager hm = MgnlContext.getHierarchyManager(ContentRepository.WEBSITE);

        String stmt = "//*[((@jcr:primaryType='mgnl:content') and (jcr:contains(@title,'test\\?')))] order by @jcr:score";
        AdvancedResultImpl advResult = QueryExecutorHelper.execute(stmt, Query.XPATH, hm, -1, 0, null);

        Assert.assertEquals(advResult.getTotalSize(), 1);
        Assert.assertEquals(advResult.getItems().next().getTitle(), "hello test? world");
    }

    @SuppressWarnings("deprecation")
    @Test
    public void testMiddle() throws Exception
    {
        HierarchyManager hm = MgnlContext.getHierarchyManager(ContentRepository.WEBSITE);
        String stmt;
        AdvancedResultImpl advResult;

        stmt = "//*[((@jcr:primaryType='mgnl:content') and (jcr:contains(@title,'te?st')))] order by @jcr:score";
        advResult = QueryExecutorHelper.execute(stmt, Query.XPATH, hm, -1, 0, null);
        Assert.assertEquals(advResult.getTotalSize(), 0);

        stmt = "//*[((@jcr:primaryType='mgnl:content') and (jcr:contains(@title,'te\\?st')))] order by @jcr:score";
        advResult = QueryExecutorHelper.execute(stmt, Query.XPATH, hm, -1, 0, null);
        Assert.assertEquals(advResult.getTotalSize(), 1);
        Assert.assertEquals(advResult.getItems().next().getTitle(), "hello te?st world");
    }
}
