/**
 *
 * Magnolia Criteria API (http://www.openmindlab.com/lab/products/mgnlcriteria.html)
 * Copyright (C)2009 - 2010, Openmind S.r.l. http://www.openmindonline.it
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion;

import net.sourceforge.openutils.mgnlcriteria.jcr.query.Criteria;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.JCRQueryException;


/**
 * @author fgrilli
 * @version $Id: IsNotNullExpression.java 2923 2010-08-29 08:58:29Z fgiust $
 */
public class IsNotNullExpression implements Criterion
{

    private static final long serialVersionUID = 42L;

    private String nodeName;

    public IsNotNullExpression(String nodeName)
    {
        this.nodeName = nodeName;
    }

    @Override
    public String toString()
    {
        return nodeName;
    }

    /**
     * {@inheritDoc}
     */
    public String toXPathString(Criteria criteria) throws JCRQueryException
    {
        return " " + nodeName + " ";
    }
}
