/**
 *
 * Magnolia Criteria API (http://www.openmindlab.com/lab/products/mgnlcriteria.html)
 * Copyright (C)2009 - 2010, Openmind S.r.l. http://www.openmindonline.it
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion;

import java.util.Calendar;

import net.sourceforge.openutils.mgnlcriteria.jcr.query.Criteria;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.JCRQueryException;


/**
 * @author fgrilli
 * @version $Id: BetweenExpression.java 2923 2010-08-29 08:58:29Z fgiust $
 */
public class BetweenExpression extends BaseCriterion implements Criterion
{

    private static final long serialVersionUID = 6686395240415024541L;

    private final String propertyName;

    private final Object lo;

    private final Object hi;

    protected BetweenExpression(String propertyName, Object lo, Object hi)
    {
        this.propertyName = propertyName;
        this.lo = lo;
        this.hi = hi;
    }

    @Override
    public String toString()
    {
        return propertyName + " between " + lo + " and " + hi;
    }

    /**
     * {@inheritDoc}
     */
    public String toXPathString(Criteria criteria) throws JCRQueryException
    {
        StringBuilder fragment = new StringBuilder();
        fragment.append(" (").append(propertyName).append(" >= ");

        if (lo instanceof String && hi instanceof String)
        {
            fragment.append("'" + lo + "' and " + propertyName + " <= '" + hi + "'");
        }
        else if (lo instanceof Number && hi instanceof Number)
        {
            fragment.append(lo + " and " + propertyName + " <= " + hi);
        }
        else if (lo instanceof Calendar && hi instanceof Calendar)
        {
            Calendar cal = (Calendar) lo;
            Calendar cal2 = (Calendar) hi;
            String fmt;
            String fmt2;

            synchronized (DATE_FORMAT)
            {
                DATE_FORMAT.setCalendar(cal);
                fmt = DATE_FORMAT.format(cal.getTime());
                DATE_FORMAT.setCalendar(cal2);
                fmt2 = DATE_FORMAT.format(cal2.getTime());
            }

            fragment.append(XS_DATETIME_FUNCTION
                + "('"
                + fmt
                + "+00:00"
                + "')  and "
                + propertyName
                + " <= "
                + XS_DATETIME_FUNCTION
                + "('"
                + fmt2
                + "+00:00"
                + "') ");
        }
        else
        {
            String msg = "values provided are not of the accepted types String, Number, Calendar";
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        fragment.append(")");
        log.debug("xpathString is {} ", fragment);
        return fragment.toString();
    }
}
