/**
 *
 * Magnolia Criteria API (http://www.openmindlab.com/lab/products/mgnlcriteria.html)
 * Copyright(C) 2009-2010, Openmind S.r.l. http://www.openmindonline.it
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.sourceforge.openutils.mgnlcriteria.advanced.impl;

import info.magnolia.cms.core.HierarchyManager;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;

import net.sourceforge.openutils.mgnlcriteria.jcr.query.JCRQueryException;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.xpath.utils.XPathTextUtils;

import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.query.QueryImpl;
import org.apache.jackrabbit.core.query.lucene.QueryResultImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * Warning, provisional class, users should not use this directly.
 * @author fgiust
 * @version $Id: QueryExecutorHelper.java 2923 2010-08-29 08:58:29Z fgiust $
 */
public final class QueryExecutorHelper
{

    /**
     * Logger.
     */
    private static Logger log = LoggerFactory.getLogger(QueryExecutorHelper.class);

    private QueryExecutorHelper()
    {
        // don't instantiate
    }

    /**
     * Executes a jcr query.
     * @param stmt the statement of the jcr query
     * @param language the language of the jcr query
     * @param hm the HirarchyManager for obtaining the QueryManager
     * @param maxResults maximun number of results to retrieve
     * @param offset the index of the first result to retrieve (0, 1, 2, ...)
     * @param spellCheckString the input string used for spell checking
     * @return the execution result
     */
    public static AdvancedResultImpl execute(String stmt, String language, HierarchyManager hm, int maxResults,
        int offset, String spellCheckString)
    {

        Session jcrSession = hm.getWorkspace().getSession();
        javax.jcr.query.QueryManager jcrQueryManager;

        try
        {
            jcrQueryManager = jcrSession.getWorkspace().getQueryManager();

            QueryImpl query = (QueryImpl) jcrQueryManager.createQuery(stmt, language);

            if (maxResults > 0)
            {
                query.setLimit(maxResults);
            }

            if (offset > 0)
            {
                query.setOffset(offset);
            }

            int pageNumberStartingFromOne = 1;
            if (maxResults > 0 && offset > maxResults - 1)
            {
                pageNumberStartingFromOne = (offset / maxResults) + 1;
            }

            Query spellCheckerQuery = null;

            if (StringUtils.isNotBlank(spellCheckString))
            {
                spellCheckerQuery = jcrQueryManager.createQuery(
                    "/jcr:root[rep:spellcheck('"
                        + XPathTextUtils.stringToJCRSearchExp(spellCheckString)
                        + "')]/(rep:spellcheck())",
                    Query.XPATH);
            }

            return new AdvancedResultImpl(
                (QueryResultImpl) query.execute(),
                maxResults,
                pageNumberStartingFromOne,
                stmt,
                hm,
                spellCheckerQuery);

        }
        catch (InvalidQueryException e)
        {
            JCRQueryException jqe = new JCRQueryException(stmt, e);
            log.error(jqe.getMessage());
            throw jqe;
        }
        catch (RepositoryException e)
        {
            JCRQueryException jqe = new JCRQueryException(stmt, e);
            log.error(jqe.getMessage());
            throw jqe;
        }

    }
}
