/**
 *
 * Magnolia Criteria API (http://www.openmindlab.com/lab/products/mgnlcriteria.html)
 * Copyright(C) 2009-2010, Openmind S.r.l. http://www.openmindonline.it
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.sourceforge.openutils.mgnlcriteria.advanced.impl;

import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.security.AccessDeniedException;

import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;

import net.sourceforge.openutils.mgnlcriteria.jcr.query.AdvancedResultItem;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * @author fgiust
 * @version $Id: AdvancedResultItemImpl.java 2889 2010-08-25 08:20:27Z fgiust $
 */
public class AdvancedResultItemImpl extends MappedDefaultContent implements AdvancedResultItem
{

    private final Row row;

    /**
     * Logger.
     */
    private Logger log = LoggerFactory.getLogger(AdvancedResultItemImpl.class);

    /**
     * @param elem
     * @param hierarchyManager
     * @throws RepositoryException
     * @throws AccessDeniedException
     */
    public AdvancedResultItemImpl(Row row, HierarchyManager hierarchyManager)
        throws RepositoryException,
        AccessDeniedException
    {
        super(row.getNode(), hierarchyManager);
        this.row = row;
    }

    /**
     * {@inheritDoc}
     */
    public String getExcerpt()
    {

        return getExcerpt(".");
    }

    /**
     * {@inheritDoc}
     */
    public String getExcerpt(String selector)
    {

        Value excerptValue;
        try
        {
            excerptValue = row.getValue("rep:excerpt(" + selector + ")");
        }
        catch (RepositoryException e)
        {
            log.warn("Error getting excerpt for " + this.getHandle(), e);
            return null;
        }

        if (excerptValue != null)
        {
            try
            {
                return excerptValue.getString();
            }
            catch (RepositoryException e)
            {
                log.warn("Error getting excerpt for " + this.getHandle(), e);
                return null;
            }
        }

        return null;
    }

    /**
     * {@inheritDoc}
     */
    public double getScore()
    {
        return getScore(".");
    }

    /**
     * {@inheritDoc}
     */
    public double getScore(String selector)
    {
        try
        {
            return row.getScore(selector);
        }
        catch (RepositoryException e)
        {
            log.warn("Error getting score for " + this.getHandle(), e);
            return 0;
        }
    }

}
