/**
 *
 * Magnolia Criteria API (http://www.openmindlab.com/lab/products/mgnlcriteria.html)
 * Copyright (C)2009 - 2010, Openmind S.r.l. http://www.openmindonline.it
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.sourceforge.openutils.mgnlcriteria.advanced.impl;

import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.security.AccessDeniedException;

import java.util.NoSuchElementException;

import javax.jcr.query.RowIterator;

import net.sourceforge.openutils.mgnlcriteria.jcr.query.AdvancedResultItem;


/**
 * @author dschivo
 * @version $Id: AccessibleResultItemResultIterator.java 2854 2010-08-19 09:25:38Z fgiust $
 */
public class AccessibleResultItemResultIterator extends AdvancedResultItemResultIterator
{

    /**
     * Local variable storing the next accessible result. Method hasNext() fetches it, method next() resets it.
     */
    private AdvancedResultItem next;

    /**
     *
     */
    public AccessibleResultItemResultIterator(RowIterator rowIterator, HierarchyManager hm)
    {
        super(rowIterator, hm);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean hasNext()
    {
        // already fetched, method next() not yet called
        if (next != null)
        {
            return true;
        }
        // no more results
        if (!super.hasNext())
        {
            return false;
        }
        // search for the next accessible result
        do
        {
            try
            {
                next = super.next();
            }
            catch (RuntimeException e)
            {
                // if it is an access-denied exception then ignore it
                if (!(e.getCause() instanceof AccessDeniedException))
                {
                    throw e;
                }
            }
        }
        while (next == null && super.hasNext());
        // return true if a next result exists and it is accessible
        return next != null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AdvancedResultItem next()
    {
        // no more results
        if (next == null && !hasNext())
        {
            throw new NoSuchElementException();
        }
        // reset the local variable before returning its value
        AdvancedResultItem result = next;
        next = null;
        return result;
    }
}
