/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcriteria.jcr.query.xpath.impl;

import info.magnolia.context.MgnlContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.openutils.mgnlcriteria.advanced.impl.QueryExecutorHelper;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.AdvancedResult;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.Criteria;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.TranslatableCriteria;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Criterion;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Order;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.xpath.JCRMagnoliaCriteriaQueryTranslator;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.xpath.XPathSelect;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.xpath.utils.XPathTextUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCriteriaImpl
implements TranslatableCriteria {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected String path = "//*";
    protected Class<?> classType;
    protected List<TranslatableCriteria.CriterionEntry> criterionEntries = new ArrayList<TranslatableCriteria.CriterionEntry>();
    protected List<TranslatableCriteria.OrderEntry> orderEntries = new ArrayList<TranslatableCriteria.OrderEntry>();
    protected int maxResults;
    protected int offset;
    protected String spellCheckString;
    protected String workspace = "website";

    protected AbstractCriteriaImpl() {
    }

    @Override
    public Collection<TranslatableCriteria.CriterionEntry> getCriterionEntries() {
        return Collections.unmodifiableCollection(this.criterionEntries);
    }

    @Override
    public Collection<TranslatableCriteria.OrderEntry> getOrderEntries() {
        return Collections.unmodifiableCollection(this.orderEntries);
    }

    @Override
    public Criteria add(Criterion criterion) {
        this.criterionEntries.add(new TranslatableCriteria.CriterionEntry(criterion, this));
        return this;
    }

    @Override
    public Criteria addOrder(Order order) {
        this.orderEntries.add(new TranslatableCriteria.OrderEntry(order, this));
        return this;
    }

    @Override
    public Criteria setBasePath(String path) {
        this.path = StringUtils.contains((String)path, (String)"*") ? path : (StringUtils.isEmpty((String)StringUtils.remove((String)path, (char)'/')) ? "//*" : "/" + StringUtils.defaultString((String)StringUtils.removeEnd((String)path, (String)"/")) + "//*");
        return this;
    }

    public int getFirstResult() {
        return this.offset;
    }

    @Override
    public Criteria setFirstResult(int firstResult) {
        this.offset = firstResult;
        return this;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    @Override
    public Criteria setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @Override
    public Criteria setPaging(int itemsPerPage, int pageNumberStartingFromOne) {
        this.maxResults = itemsPerPage;
        this.offset = (Math.max(pageNumberStartingFromOne, 1) - 1) * this.maxResults;
        return this;
    }

    @Override
    public Criteria setSpellCheckString(String spellCheckString) {
        this.spellCheckString = spellCheckString;
        return this;
    }

    @Override
    public Criteria setWorkspace(String workspace) {
        this.workspace = workspace;
        return this;
    }

    @Override
    public String toXpathExpression() {
        JCRMagnoliaCriteriaQueryTranslator translator = new JCRMagnoliaCriteriaQueryTranslator(this);
        XPathSelect statement = new XPathSelect();
        statement.setRoot(XPathTextUtils.encodeDigitsInPath(this.path));
        statement.setPredicate(translator.getPredicate());
        statement.setOrderByClause(translator.getOrderBy());
        String stmt = statement.toStatementString();
        return stmt;
    }

    @Override
    public AdvancedResult execute() {
        String language = "xpath";
        String stmt = this.toXpathExpression();
        return QueryExecutorHelper.execute(stmt, language, MgnlContext.getHierarchyManager((String)this.workspace), this.maxResults, this.offset, this.spellCheckString);
    }
}

