/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcriteria.jcr.query.lucene;

import info.magnolia.cms.security.AccessManager;
import info.magnolia.cms.security.Permission;
import info.magnolia.cms.util.SimpleUrlPattern;
import info.magnolia.context.MgnlContext;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.lucene.MatchAllDocsQuery;
import org.apache.jackrabbit.core.query.lucene.QueryDecoratorSupport;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;

public class AclQueryDecorator
extends QueryDecoratorSupport {
    private final SessionImpl session;

    public AclQueryDecorator(SessionImpl session, SearchIndex index) {
        super(index);
        this.session = session;
    }

    public Query applyAcl(Query query) throws RepositoryException {
        ArrayList<Object[]> aclQueries = new ArrayList<Object[]>();
        AccessManager accessManager = MgnlContext.getAccessManager((String)this.session.getWorkspace().getName());
        List permissions = accessManager.getPermissionList();
        if (!permissions.isEmpty()) {
            try {
                Field patternStringField = SimpleUrlPattern.class.getDeclaredField("patternString");
                patternStringField.setAccessible(true);
                for (Permission permission : permissions) {
                    String pattern;
                    String[] tokens;
                    if (!(permission.getPattern() instanceof SimpleUrlPattern) || (tokens = StringUtils.splitPreserveAllTokens((String)(pattern = (String)patternStringField.get(permission.getPattern())), (char)'/')).length <= 2 || !"".equals(tokens[0]) || !"*".equals(tokens[tokens.length - 1])) continue;
                    Query q = null;
                    for (int i = 1; i < tokens.length - 1; ++i) {
                        q = q == null ? this.descendantSelfAxisQuery(this.jackrabbitTermQuery("_:PARENT"), this.nameQuery(tokens[i])) : this.childAxisQuery(q, tokens[i]);
                    }
                    q = this.descendantSelfAxisQuery(this.booleanQuery(q), (Query)new MatchAllDocsQuery());
                    BooleanClause.Occur o = (permission.getPermissions() & 8L) != 0L ? BooleanClause.Occur.MUST : BooleanClause.Occur.MUST_NOT;
                    aclQueries.add(new Object[]{q, o});
                }
            }
            catch (SecurityException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (NoSuchFieldException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        if (!aclQueries.isEmpty()) {
            Query[] qs = new Query[1 + aclQueries.size()];
            BooleanClause.Occur[] os = new BooleanClause.Occur[qs.length];
            qs[0] = query;
            os[0] = BooleanClause.Occur.MUST;
            for (int i = 1; i < qs.length; ++i) {
                Object[] qo = (Object[])aclQueries.get(i - 1);
                qs[i] = (Query)qo[0];
                os[i] = (BooleanClause.Occur)qo[1];
            }
            query = this.booleanQuery(qs, os);
        }
        return query;
    }
}

