/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcriteria.advanced.impl;

import info.magnolia.cms.core.HierarchyManager;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import net.sourceforge.openutils.mgnlcriteria.advanced.impl.AdvancedResultImpl;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.JCRQueryException;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.xpath.utils.XPathTextUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.query.QueryImpl;
import org.apache.jackrabbit.core.query.lucene.QueryResultImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryExecutorHelper {
    private static Logger log = LoggerFactory.getLogger(QueryExecutorHelper.class);

    private QueryExecutorHelper() {
    }

    public static AdvancedResultImpl execute(String stmt, String language, HierarchyManager hm, int maxResults, int offset, String spellCheckString) {
        Session jcrSession = hm.getWorkspace().getSession();
        try {
            QueryManager jcrQueryManager = jcrSession.getWorkspace().getQueryManager();
            QueryImpl query = (QueryImpl)jcrQueryManager.createQuery(stmt, language);
            if (maxResults > 0) {
                query.setLimit((long)maxResults);
            }
            if (offset > 0) {
                query.setOffset((long)offset);
            }
            int pageNumberStartingFromOne = 1;
            if (maxResults > 0 && offset > maxResults - 1) {
                pageNumberStartingFromOne = offset / maxResults + 1;
            }
            Query spellCheckerQuery = null;
            if (StringUtils.isNotBlank((String)spellCheckString)) {
                spellCheckerQuery = jcrQueryManager.createQuery("/jcr:root[rep:spellcheck('" + XPathTextUtils.stringToJCRSearchExp(spellCheckString) + "')]/(rep:spellcheck())", "xpath");
            }
            return new AdvancedResultImpl((QueryResultImpl)query.execute(), maxResults, pageNumberStartingFromOne, stmt, hm, spellCheckerQuery);
        }
        catch (InvalidQueryException e) {
            JCRQueryException jqe = new JCRQueryException(stmt, e);
            log.error(jqe.getMessage());
            throw jqe;
        }
        catch (RepositoryException e) {
            JCRQueryException jqe = new JCRQueryException(stmt, e);
            log.error(jqe.getMessage());
            throw jqe;
        }
    }
}

