/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcriteria.advanced.impl;

import info.magnolia.cms.beans.runtime.FileProperties;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.DefaultContent;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.NodeData;
import info.magnolia.cms.security.AccessDeniedException;
import info.magnolia.link.LinkException;
import info.magnolia.link.LinkTransformer;
import info.magnolia.link.LinkTransformerManager;
import info.magnolia.link.LinkUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedDefaultContent
extends DefaultContent
implements Map<String, Object> {
    private Logger log = LoggerFactory.getLogger(MappedDefaultContent.class);

    public MappedDefaultContent(Item elem, HierarchyManager hierarchyManager) throws RepositoryException, AccessDeniedException {
        super(elem, hierarchyManager);
    }

    @Override
    public int size() {
        return this.getNodeDataCollection().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getNodeDataCollection().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getNodeData((String)key).isExist() || this.hasProperty(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public Object get(Object key) {
        Object value;
        block18: {
            try {
                if (this.hasNodeData((String)key)) break block18;
                if ("uuid".equalsIgnoreCase((String)key)) {
                    key = "UUID";
                }
                if (!this.hasProperty(key)) break block18;
                try {
                    return PropertyUtils.getProperty((Object)this, (String)((String)key));
                }
                catch (IllegalAccessException e) {
                    this.log.error("can't read property " + key + " from the node " + this, (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    this.log.error("can't read property " + key + " from the node " + this, (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    this.log.error("can't read property " + key + " from the node " + this, (Throwable)e);
                }
            }
            catch (RepositoryException e) {
                this.log.error("can't check for node data {" + key + "}", (Throwable)e);
            }
        }
        NodeData nodeData = this.getNodeData((String)key);
        int type = nodeData.getType();
        if (type == 5) {
            value = nodeData.getDate();
        } else if (type == 2) {
            FileProperties props = new FileProperties((Content)this, (String)key);
            value = props.getProperty("path");
        } else if (nodeData.isMultiValue() == 1) {
            Value[] values = nodeData.getValues();
            String[] valueStrings = new String[values.length];
            for (int j = 0; j < values.length; ++j) {
                try {
                    valueStrings[j] = values[j].getString();
                    continue;
                }
                catch (RepositoryException e) {
                    this.log.debug(e.getMessage());
                }
            }
            value = valueStrings;
        } else {
            try {
                value = LinkUtil.convertLinksFromUUIDPattern((String)nodeData.getString(), (LinkTransformer)LinkTransformerManager.getInstance().getBrowserLink(this.getHandle()));
            }
            catch (LinkException e) {
                this.log.warn("Failed to parse links with from " + nodeData.getName(), (Throwable)e);
                value = nodeData.getString();
            }
        }
        return value;
    }

    protected boolean hasProperty(Object key) {
        try {
            return PropertyUtils.getPropertyDescriptor((Object)this, (String)((String)key)) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Object put(String key, Object value) {
        return null;
    }

    @Override
    public Object remove(Object key) {
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
    }

    @Override
    public void clear() {
    }

    @Override
    public Set<String> keySet() {
        Collection nodeDataCollection = this.getNodeDataCollection();
        HashSet<String> keys = new HashSet<String>();
        Iterator iter = nodeDataCollection.iterator();
        while (iter.hasNext()) {
            keys.add(((NodeData)iter.next()).getName());
        }
        return keys;
    }

    @Override
    public Collection<Object> values() {
        Collection nodeDataCollection = this.getNodeDataCollection();
        ArrayList<Object> values = new ArrayList<Object>();
        Iterator iter = nodeDataCollection.iterator();
        while (iter.hasNext()) {
            values.add(((NodeData)iter.next()).getString());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        Collection nodeDataCollection = this.getNodeDataCollection();
        HashSet<Map.Entry<String, Object>> keys = new HashSet<Map.Entry<String, Object>>();
        for (NodeData nd : nodeDataCollection) {
            final String key = nd.getName();
            final String value = nd.getString();
            keys.add(new Map.Entry<String, Object>(){

                @Override
                public String getKey() {
                    return key;
                }

                @Override
                public Object getValue() {
                    return value;
                }

                @Override
                public Object setValue(Object value2) {
                    return value2;
                }
            });
        }
        return keys;
    }
}

