/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcriteria.advanced.impl;

import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.security.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import net.sourceforge.openutils.mgnlcriteria.advanced.impl.MappedDefaultContent;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.AdvancedResultItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedResultItemImpl
extends MappedDefaultContent
implements AdvancedResultItem {
    private final Row row;
    private Logger log = LoggerFactory.getLogger(AdvancedResultItemImpl.class);

    public AdvancedResultItemImpl(Row row, HierarchyManager hierarchyManager) throws RepositoryException, AccessDeniedException {
        super((Item)row.getNode(), hierarchyManager);
        this.row = row;
    }

    public String getExcerpt() {
        return this.getExcerpt(".");
    }

    public String getExcerpt(String selector) {
        Value excerptValue;
        try {
            excerptValue = this.row.getValue("rep:excerpt(" + selector + ")");
        }
        catch (RepositoryException e) {
            this.log.warn("Error getting excerpt for " + this.getHandle(), (Throwable)e);
            return null;
        }
        if (excerptValue != null) {
            try {
                return excerptValue.getString();
            }
            catch (RepositoryException e) {
                this.log.warn("Error getting excerpt for " + this.getHandle(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public double getScore() {
        return this.getScore(".");
    }

    public double getScore(String selector) {
        try {
            return this.row.getScore(selector);
        }
        catch (RepositoryException e) {
            this.log.warn("Error getting score for " + this.getHandle(), (Throwable)e);
            return 0.0;
        }
    }
}

