/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcas;

import info.magnolia.cms.security.User;
import info.magnolia.cms.security.auth.callback.RealmCallback;
import info.magnolia.cms.util.BooleanUtil;
import info.magnolia.jaas.principal.EntityImpl;
import info.magnolia.jaas.principal.GroupListImpl;
import info.magnolia.jaas.principal.RoleListImpl;
import info.magnolia.jaas.sp.AbstractLoginModule;
import info.magnolia.jaas.sp.UserAwareLoginModule;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import net.sourceforge.openutils.mgnlcas.CasMagnoliaUser;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ProxyTicketValidator;
import org.jasig.cas.client.validation.TicketValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CASAuthenticationModule
extends AbstractLoginModule
implements LoginModule,
UserAwareLoginModule {
    protected Subject subject;
    protected CallbackHandler callbackHandler;
    protected String casValidateUrl;
    protected String service;
    protected AttributePrincipal principal;
    protected User user;
    private boolean skipOnPreviousSuccess;
    private String defaultGroup;
    private String defaultRole;
    private String rolesAttribute = "roles";
    private String groupsAttribute = "groups";
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.casValidateUrl = (String)options.get("cas_validate_url");
        this.service = (String)options.get("service");
        this.defaultGroup = (String)options.get("default_group");
        this.defaultRole = (String)options.get("default_role");
        if (options.get("roles_attribute") != null) {
            this.rolesAttribute = (String)options.get("roles_attribute");
        }
        if (options.get("groups_attribute") != null) {
            this.groupsAttribute = (String)options.get("groups_attribute");
        }
        this.skipOnPreviousSuccess = BooleanUtil.toBoolean((String)((String)options.get("skip_on_previous_success")), (boolean)false);
    }

    public boolean login() throws LoginException {
        String ticket;
        if (this.skipOnPreviousSuccess && this.getSharedStatus() == 1) {
            return true;
        }
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available");
        }
        ArrayList<TextInputCallback> callbacksList = new ArrayList<TextInputCallback>();
        TextInputCallback ticketCallback = new TextInputCallback("ticket");
        TextInputCallback serviceCallback = null;
        TextInputCallback casValidateUrlCallback = null;
        RealmCallback realmCallback = null;
        callbacksList.add(ticketCallback);
        if (StringUtils.isBlank((String)this.service)) {
            serviceCallback = new TextInputCallback("service");
            callbacksList.add(serviceCallback);
        }
        if (StringUtils.isBlank((String)this.service)) {
            casValidateUrlCallback = new TextInputCallback("casValidateUrl");
            callbacksList.add(casValidateUrlCallback);
        }
        if (this.useRealmCallback) {
            realmCallback = new RealmCallback();
            callbacksList.add((TextInputCallback)realmCallback);
        }
        this.success = false;
        Callback[] callbacks = callbacksList.toArray(new Callback[callbacksList.size()]);
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Exception caught", (Throwable)e);
            }
            throw new LoginException(e.toString());
        }
        catch (UnsupportedCallbackException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(e.getMessage(), (Throwable)e);
            }
            throw new LoginException(e.getCallback().toString() + " not available");
        }
        if (this.useRealmCallback) {
            this.realm = StringUtils.defaultIfEmpty((String)realmCallback.getRealm(), (String)this.realm);
        }
        if (StringUtils.isNotEmpty((String)(ticket = ticketCallback.getText()))) {
            Assertion assertion;
            if (serviceCallback != null) {
                this.service = serviceCallback.getText();
            }
            if (casValidateUrlCallback != null) {
                this.casValidateUrl = casValidateUrlCallback.getText();
            }
            Cas20ProxyTicketValidator pv = new Cas20ProxyTicketValidator(this.casValidateUrl);
            try {
                assertion = pv.validate(ticket, this.service);
            }
            catch (TicketValidationException e) {
                throw new LoginException(e.getMessage());
            }
            if (assertion.getPrincipal() != null) {
                this.principal = assertion.getPrincipal();
                this.log.debug("principal is {}", (Object)this.principal.getName());
                this.subject.getPrincipals().add((Principal)this.principal);
                this.setEntity();
                this.user = new CasMagnoliaUser(this.subject);
                this.success = true;
                this.setSharedStatus(1);
            }
        }
        return this.success;
    }

    public void validateUser() throws LoginException {
    }

    public boolean commit() throws LoginException {
        if (this.principal != null) {
            this.subject.getPrincipals().add((Principal)this.principal);
            return true;
        }
        return false;
    }

    public User getUser() {
        return this.user;
    }

    public boolean release() {
        if (this.principal != null) {
            this.principal = null;
            this.user = null;
            return true;
        }
        return false;
    }

    public void setACL() {
    }

    public void setEntity() {
        EntityImpl entity = new EntityImpl();
        entity.addProperty("name", (Object)this.principal.getName());
        Map attributes = this.principal.getAttributes();
        for (Map.Entry attr : attributes.entrySet()) {
            entity.addProperty((String)attr.getKey(), attr.getValue());
        }
        String fullName = (String)attributes.get("title");
        if (fullName != null) {
            this.log.debug("full name is {}", (Object)fullName);
            entity.addProperty("fullName", (Object)fullName);
        }
        entity.addProperty("language", (Object)"en");
        this.subject.getPrincipals().add((Principal)entity);
        Object[] roles = StringUtils.split((String)((String)attributes.get(this.rolesAttribute)));
        Object[] groups = StringUtils.split((String)((String)attributes.get(this.groupsAttribute)));
        if (roles == null) {
            roles = new String[]{};
        }
        if (groups == null) {
            groups = new String[]{};
        }
        if (this.defaultGroup != null) {
            groups = (String[])ArrayUtils.add((Object[])groups, (Object)this.defaultGroup);
        }
        if (this.defaultRole != null) {
            roles = (String[])ArrayUtils.add((Object[])roles, (Object)this.defaultRole);
        }
        this.addGroups((String[])groups);
        this.addRoles((String[])roles);
    }

    protected void addGroups(String[] groups) {
        GroupListImpl groupList = new GroupListImpl();
        for (int j = 0; j < groups.length; ++j) {
            String group = groups[j];
            groupList.add(group);
            this.addGroupName(group);
        }
        this.subject.getPrincipals().add((Principal)groupList);
    }

    protected void addRoles(String[] roles) {
        RoleListImpl roleList = new RoleListImpl();
        for (int j = 0; j < roles.length; ++j) {
            String role = roles[j];
            roleList.add(role);
            this.addRoleName(role);
        }
        this.subject.getPrincipals().add((Principal)roleList);
    }
}

