/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcas;

import info.magnolia.cms.security.SecuritySupport;
import info.magnolia.cms.security.User;
import info.magnolia.cms.security.auth.callback.RealmCallback;
import info.magnolia.cms.security.auth.login.LoginHandler;
import info.magnolia.cms.security.auth.login.LoginHandlerBase;
import info.magnolia.cms.security.auth.login.LoginResult;
import java.io.IOException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.openutils.mgnlcas.RequestUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasLogin
extends LoginHandlerBase
implements LoginHandler {
    private static final Logger log = LoggerFactory.getLogger(CasLogin.class);
    private String artifactParameterName = "ticket";
    private String jaasChain = "magnolia";
    private String realm;
    private String casValidateUrl;

    public void setArtifactParameterName(String artifactParameterName) {
        this.artifactParameterName = artifactParameterName;
    }

    public String getJaasChain() {
        return this.jaasChain;
    }

    public void setJaasChain(String jaasChain) {
        this.jaasChain = jaasChain;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getCasValidateUrl() {
        return this.casValidateUrl;
    }

    public void setCasValidateUrl(String casValidateUrl) {
        this.casValidateUrl = casValidateUrl;
    }

    public LoginResult handle(HttpServletRequest request, HttpServletResponse response) {
        String ticket = request.getParameter(this.artifactParameterName);
        if (StringUtils.isNotEmpty((String)ticket)) {
            String service = RequestUtils.absoluteUrl(request);
            if (service.lastIndexOf("/") == service.length() - 1) {
                service = service.substring(0, service.lastIndexOf("/"));
            }
            CasCallBackHandler handler = new CasCallBackHandler(service, ticket, this.realm);
            return this.authenticateCas(handler, this.getJaasChain());
        }
        return LoginResult.NOT_HANDLED;
    }

    protected LoginResult authenticateCas(CasCallBackHandler callbackHandler, String customLoginModule) {
        try {
            LoginContext loginContext = new LoginContext(StringUtils.defaultString((String)customLoginModule, (String)"magnolia"), callbackHandler);
            loginContext.login();
            Subject subject = loginContext.getSubject();
            User user = SecuritySupport.Factory.getInstance().getUserManager().getUser(subject);
            if (user != null) {
                user.setSubject(subject);
            } else {
                log.error("Unable to obtain a user from userManager, maybe the external user manager is not configured for the cas realm?");
            }
            return new LoginResult(1, user);
        }
        catch (LoginException e) {
            log.info("Can't login due to:", (Throwable)e);
            return new LoginResult(2, e);
        }
    }

    public class CasCallBackHandler
    implements CallbackHandler {
        private String service;
        private String ticket;
        private String realm;

        public CasCallBackHandler(String service, String ticket, String realm) {
            this.service = service;
            this.ticket = ticket;
            this.realm = realm;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof TextInputCallback) {
                    TextInputCallback text = (TextInputCallback)callbacks[i];
                    if ("ticket".equals(text.getPrompt())) {
                        log.info(this.getTicket());
                        text.setText(this.getTicket());
                        continue;
                    }
                    if ("service".equals(text.getPrompt())) {
                        log.info(this.getService());
                        text.setText(this.getService());
                        continue;
                    }
                    if (!"casValidateUrl".equals(text.getPrompt())) continue;
                    log.info(CasLogin.this.casValidateUrl);
                    text.setText(CasLogin.this.casValidateUrl);
                    continue;
                }
                if (callbacks[i] instanceof RealmCallback) {
                    log.info(this.realm);
                    ((RealmCallback)callbacks[i]).setRealm(this.realm);
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "Callback class not supported");
            }
        }

        public String getTicket() {
            return this.ticket;
        }

        public String getService() {
            return this.service;
        }

        public String getRealm() {
            return this.realm;
        }
    }
}

