/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcas;

import info.magnolia.cms.security.auth.callback.AbstractHttpClientCallback;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sourceforge.openutils.mgnlcas.RequestUtils;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasClientCallback
extends AbstractHttpClientCallback {
    public static final String CONST_CAS_GATEWAY = "_const_cas_gateway_";
    public static final String CONST_CAS_ASSERTION = "_const_cas_assertion_";
    private Logger log = LoggerFactory.getLogger(CasClientCallback.class);
    private String artifactParameterName = "ticket";
    private String serviceParameterName = "service";
    private boolean encodeServiceUrl = true;
    private String casServerLoginUrl;
    private boolean renew;
    private boolean gateway;

    public final void setRenew(boolean renew) {
        this.renew = renew;
    }

    public final void setGateway(boolean gateway) {
        this.gateway = gateway;
    }

    public final void setCasServerLoginUrl(String casServerLoginUrl) {
        this.casServerLoginUrl = casServerLoginUrl;
    }

    public void setArtifactParameterName(String artifactParameterName) {
        this.artifactParameterName = artifactParameterName;
    }

    public void setServiceParameterName(String serviceParameterName) {
        this.serviceParameterName = serviceParameterName;
    }

    public void setEncodeServiceUrl(boolean encodeServiceUrl) {
        this.encodeServiceUrl = encodeServiceUrl;
    }

    public void doCallback(HttpServletRequest request, HttpServletResponse response) {
        boolean wasGatewayed;
        HttpSession session = request.getSession(false);
        if (session != null && session.getAttribute("info.magnolia.context.UserContextImpl.user") != null) {
            try {
                request.getRequestDispatcher("/errors/401.html").forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        String ticket = request.getParameter(this.artifactParameterName);
        Assertion assertion = session != null ? (Assertion)session.getAttribute(CONST_CAS_ASSERTION) : null;
        boolean bl = wasGatewayed = session != null && session.getAttribute(CONST_CAS_GATEWAY) != null;
        if (CommonUtils.isBlank((String)ticket) && assertion == null && !wasGatewayed) {
            String service = RequestUtils.absoluteUrl(request);
            this.log.debug("no ticket and no assertion found");
            if (this.gateway) {
                this.log.debug("setting gateway attribute in session");
                request.getSession(true).setAttribute(CONST_CAS_GATEWAY, (Object)"yes");
            }
            String serviceUrl = CommonUtils.constructServiceUrl((HttpServletRequest)request, (HttpServletResponse)response, (String)service, null, (String)this.artifactParameterName, (boolean)this.encodeServiceUrl);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Constructed service url: " + serviceUrl);
            }
            String urlToRedirectTo = CommonUtils.constructRedirectUrl((String)this.casServerLoginUrl, (String)this.serviceParameterName, (String)serviceUrl, (boolean)this.renew, (boolean)this.gateway);
            urlToRedirectTo = urlToRedirectTo + "&locale=" + request.getLocale().toString();
            if (this.log.isDebugEnabled()) {
                this.log.debug("redirecting to \"" + urlToRedirectTo + "\"");
            }
            try {
                response.sendRedirect(urlToRedirectTo);
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            return;
        }
        if (session != null) {
            this.log.debug("removing gateway attribute from session");
            session.setAttribute(CONST_CAS_GATEWAY, null);
        }
    }
}

