/*
 * Copyright Openmind http://www.openmindonline.it
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package it.openutils.hibernate.security.filter;

import it.openutils.hibernate.security.dataobject.PermissionEnum;

import org.acegisecurity.ConfigAttribute;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * @author fcarone
 * @version $Id: SecurityRuleBaseHandler.java 729 2008-03-06 09:26:46Z fcarone $
 */
public abstract class SecurityRuleBaseHandler
{

    /**
     * Logger.
     */
    private Logger log = LoggerFactory.getLogger(SecurityRuleBaseHandler.class);

    /**
     * {@inheritDoc}
     */
    public boolean supports(ConfigAttribute attribute)
    {
        log.debug("Evaluating attribute {}", attribute.getAttribute());

        for (PermissionEnum permission : PermissionEnum.values())
        {
            if (StringUtils.equals(permission.getValue(), attribute.getAttribute()))
            {
                log.debug("Support ok.");
                return true;
            }
        }
        log.debug("Not supporting attribute.");
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("unchecked")
    public boolean supports(Class clazz)
    {
        return true;
    }

}
