/*
 * Copyright Openmind http://www.openmindonline.it
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package it.openutils.hibernate.security.dataobject;

/**
 * @author fcarone
 * @version $Id: PermissionEnum.java 729 2008-03-06 09:26:46Z fcarone $
 */
public enum PermissionEnum {

    /**
     * Load, Create, Modify, Delete permissions
     */
    LOAD("LOAD"), CREATE("CREATE"), MODIFY("MODIFY"), DELETE("DELETE");

    private String value;

    /**
     * @param value The literal value for the needed enumeration object
     */
    PermissionEnum(String value)
    {
        this.value = value;
    }


    /**
     * Returns the value.
     * @return the value
     */
    public String getValue()
    {
        return value;
    }

}
