/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.hibernate.security.filter.utils;

import it.openutils.hibernate.security.dataobject.PermissionEnum;
import it.openutils.hibernate.security.dataobject.SecurityRule;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.acegisecurity.Authentication;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.GrantedAuthority;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityRuleUtils {
    private Logger log = LoggerFactory.getLogger(SecurityRuleUtils.class);

    public boolean checkPermissions(List<SecurityRule> rules, ConfigAttributeDefinition config) {
        this.log.debug("Evaluation permissions");
        Iterator iterator = config.getConfigAttributes();
        while (iterator.hasNext()) {
            String attribute = ((ConfigAttribute)iterator.next()).getAttribute();
            for (SecurityRule rule : rules) {
                if (!rule.isEnabled()) {
                    this.log.debug("Skipping disabled rule {}", (Object)rule);
                    continue;
                }
                for (PermissionEnum permission : rule.getPermissions()) {
                    if (!StringUtils.equals((String)permission.getValue(), (String)attribute)) continue;
                    this.log.debug("Matching permission: {}", (Object)permission.getValue());
                    return true;
                }
            }
        }
        this.log.debug("No matching permissions found.");
        return false;
    }

    public boolean checkRules(List<SecurityRule> rules, Object argument) {
        this.log.debug("Evaluating rules.");
        try {
            block8: for (SecurityRule rule : rules) {
                if (!rule.isEnabled()) continue;
                String objProperty = BeanUtils.getSimpleProperty((Object)argument, (String)rule.getProperty());
                switch (rule.getModifier()) {
                    case EQUALS: {
                        if (!StringUtils.equals((String)objProperty, (String)rule.getValue())) continue block8;
                        this.log.debug("Matching rule found: {}", (Object)rule);
                        return true;
                    }
                    case NOT: {
                        if (StringUtils.equals((String)objProperty, (String)rule.getValue())) continue block8;
                        this.log.debug("Matching rule found: {}", (Object)rule);
                        return true;
                    }
                }
                throw new RuntimeException("Modifier " + (Object)((Object)rule.getModifier()) + " is not recognized");
            }
        }
        catch (NoSuchMethodException e) {
            this.log.error("{}", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.log.error("{}", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.log.error("{}", (Throwable)e);
        }
        this.log.debug("No matching rules found.");
        return false;
    }

    public List<String> getRolesFromAuthentication(Authentication authentication) {
        ArrayList<String> roles = new ArrayList<String>();
        for (GrantedAuthority authority : authentication.getAuthorities()) {
            this.log.debug("Granted authority for user {}: {}", (Object)authentication.getName(), (Object)authority.getAuthority());
            roles.add(authority.getAuthority());
        }
        return roles;
    }

    public String getClassName(Object object) {
        if (StringUtils.contains((String)object.getClass().getName(), (String)"$$")) {
            return StringUtils.substringBefore((String)object.getClass().getName(), (String)"$$");
        }
        return object.getClass().getName();
    }
}

