/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.hibernate.security.filter;

import it.openutils.hibernate.security.dataobject.SecurityRule;
import it.openutils.hibernate.security.filter.utils.SecurityRuleUtils;
import it.openutils.hibernate.security.services.SecurityRuleManager;
import java.util.ArrayList;
import java.util.List;
import org.acegisecurity.Authentication;
import org.acegisecurity.ConfigAttributeDefinition;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityRulePredicate
implements Predicate {
    private Logger log = LoggerFactory.getLogger(SecurityRulePredicate.class);
    private Authentication authentication;
    private SecurityRuleManager securityRuleManager;
    private ConfigAttributeDefinition configAttribute;
    private SecurityRuleUtils ruleUtils = new SecurityRuleUtils();
    private boolean denyIfNoRulesFound = true;

    public SecurityRulePredicate(Authentication authentication, ConfigAttributeDefinition configAttribute, SecurityRuleManager securityRuleManager) {
        this.authentication = authentication;
        this.securityRuleManager = securityRuleManager;
        this.configAttribute = configAttribute;
    }

    public boolean evaluate(Object object) {
        List<String> roles = this.ruleUtils.getRolesFromAuthentication(this.authentication);
        List<SecurityRule> rules = this.findAllRules(object, roles);
        if (rules == null || rules.isEmpty()) {
            if (this.denyIfNoRulesFound) {
                this.log.debug("Returning false since no rules found and denyIfNoRulesFound is true.");
                return false;
            }
            this.log.debug("Returning true since no rules found and denyIfNoRulesFound is false.");
            return true;
        }
        this.log.debug("Evaluating rules.");
        return this.ruleUtils.checkPermissions(rules, this.configAttribute) && this.ruleUtils.checkRules(rules, object);
    }

    private List<SecurityRule> findAllRules(Object object, List<String> roles) {
        ArrayList<SecurityRule> result = new ArrayList<SecurityRule>();
        Class<Object> objectClass = object.getClass();
        while (!objectClass.isAssignableFrom(Object.class)) {
            result.addAll(this.securityRuleManager.getRulesForRoles(StringUtils.substringBefore((String)objectClass.getName(), (String)"$$"), roles));
            objectClass = objectClass.getSuperclass();
        }
        return result;
    }

    public void setDenyIfNoRulesFound(boolean denyIfNoRulesFound) {
        this.denyIfNoRulesFound = denyIfNoRulesFound;
    }
}

