/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.hibernate.security.filter;

import it.openutils.hibernate.security.dataobject.SecurityRule;
import it.openutils.hibernate.security.filter.SecurityRuleBaseHandler;
import it.openutils.hibernate.security.filter.utils.SecurityRuleUtils;
import it.openutils.hibernate.security.services.SecurityRuleManager;
import java.util.List;
import org.acegisecurity.Authentication;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.vote.AccessDecisionVoter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ReflectiveMethodInvocation;

public class SecurityRuleAccessDecisionVoter
extends SecurityRuleBaseHandler
implements AccessDecisionVoter {
    private static Logger log = LoggerFactory.getLogger(SecurityRuleAccessDecisionVoter.class);
    private SecurityRuleManager securityRuleManager;
    private SecurityRuleUtils ruleUtils = new SecurityRuleUtils();
    private boolean enabled = true;

    public int vote(Authentication authentication, Object object, ConfigAttributeDefinition config) {
        if (!this.enabled) {
            log.debug("SecurityRuleAccessDecisionVoter disabled, abstaining.");
            return 0;
        }
        List<String> roles = this.ruleUtils.getRolesFromAuthentication(authentication);
        if (object instanceof ReflectiveMethodInvocation) {
            ReflectiveMethodInvocation methodInvocation = (ReflectiveMethodInvocation)object;
            for (Object argument : methodInvocation.getArguments()) {
                log.debug("Evaluating argument {}", argument);
                List<SecurityRule> rules = this.securityRuleManager.getRulesForRoles(this.ruleUtils.getClassName(argument), roles);
                if (rules == null || rules.isEmpty()) continue;
                if (this.ruleUtils.checkPermissions(rules, config) && this.ruleUtils.checkRules(rules, argument)) {
                    log.debug("Granting access.");
                    return 1;
                }
                log.debug("Denying access.");
                return -1;
            }
        }
        log.debug("No rules found, abstaining.");
        return 0;
    }

    public void setSecurityRuleManager(SecurityRuleManager securityRuleManager) {
        this.securityRuleManager = securityRuleManager;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

