/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.hibernate.security.filter;

import it.openutils.hibernate.security.dataobject.PermissionEnum;
import it.openutils.hibernate.security.dataobject.SecurityRule;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import org.acegisecurity.util.FieldUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Filter;
import org.hibernate.HibernateException;
import org.hibernate.annotations.Table;
import org.hibernate.engine.FilterDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanFilter
implements Filter {
    private FilterDefinition filterDefinition;
    private Logger log = LoggerFactory.getLogger(JavaBeanFilter.class);

    public JavaBeanFilter(String bean, List<SecurityRule> securityRules) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, NoSuchFieldException {
        Class<?> beanClass = Class.forName(bean, true, this.getClass().getClassLoader());
        if (!beanClass.isAnnotationPresent(Entity.class)) {
            throw new IllegalArgumentException("Class " + bean + " must contain the @Entity annotation.");
        }
        if (!beanClass.isAnnotationPresent(javax.persistence.Table.class) && !beanClass.isAnnotationPresent(Table.class)) {
            throw new IllegalArgumentException("Class " + bean + " must contain the @Table annotation.");
        }
        HashMap<String, String> propertyColumnMap = new HashMap<String, String>();
        StringBuffer filterDefCondition = new StringBuffer();
        String filterName = "";
        LinkedHashMap roleRuleMap = new LinkedHashMap();
        for (SecurityRule securityRule : securityRules) {
            if (!securityRule.isEnabled()) continue;
            if (!roleRuleMap.containsKey(securityRule.getRole())) {
                roleRuleMap.put(securityRule.getRole(), new ArrayList());
            }
            ((List)roleRuleMap.get(securityRule.getRole())).add(securityRule);
        }
        for (Map.Entry entry : roleRuleMap.entrySet()) {
            filterName = filterName + (String)entry.getKey();
            List rules = (List)entry.getValue();
            if (rules == null || rules.isEmpty()) {
                this.log.debug("No rules defined for role {}", entry.getKey());
                continue;
            }
            if (!this.rulesContainLoad(rules)) {
                this.log.debug("No LOAD rules defined for role {}", entry.getKey());
                continue;
            }
            if (!StringUtils.isEmpty((String)filterDefCondition.toString())) {
                filterDefCondition.append(" OR ");
            }
            filterDefCondition.append("(");
            StringBuffer subFilterCond = new StringBuffer();
            for (SecurityRule securityRule : rules) {
                if (!securityRule.getPermissions().contains((Object)PermissionEnum.LOAD)) {
                    this.log.debug("Skipping rule {} since it is not related to LOAD.", (Object)securityRule);
                    continue;
                }
                String property = securityRule.getProperty();
                filterName = filterName + property;
                Field field = FieldUtils.getField(beanClass, (String)property);
                propertyColumnMap.put(property, field.getAnnotation(Column.class).name());
                if (!StringUtils.isEmpty((String)subFilterCond.toString())) {
                    subFilterCond.append(" AND ");
                }
                String modifier = null;
                String startQuote = null;
                String endQuote = null;
                if (String.class.isAssignableFrom(field.getType())) {
                    endQuote = startQuote = "'";
                } else if (Number.class.isAssignableFrom(field.getType())) {
                    startQuote = "";
                    endQuote = "";
                }
                switch (securityRule.getModifier()) {
                    case EQUALS: {
                        modifier = " = ";
                        break;
                    }
                    case NOT: {
                        modifier = " != ";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Modifier " + (Object)((Object)securityRule.getModifier()) + "not recognized.");
                    }
                }
                subFilterCond.append(field.getAnnotation(Column.class).name());
                subFilterCond.append(modifier);
                if (StringUtils.isNotEmpty((String)startQuote)) {
                    subFilterCond.append(startQuote);
                }
                subFilterCond.append(StringEscapeUtils.escapeSql((String)securityRule.getValue()));
                if (StringUtils.isNotEmpty((String)endQuote)) {
                    subFilterCond.append(endQuote);
                }
                filterName = filterName + securityRule.getValue();
            }
            filterDefCondition.append(subFilterCond);
            filterDefCondition.append(")");
        }
        this.filterDefinition = new FilterDefinition(Integer.toString(filterName.hashCode()), filterDefCondition.toString(), new HashMap());
    }

    private boolean rulesContainLoad(List<SecurityRule> rules) {
        for (SecurityRule rule : rules) {
            if (!rule.getPermissions().contains((Object)PermissionEnum.LOAD)) continue;
            return true;
        }
        return false;
    }

    public FilterDefinition getFilterDefinition() {
        return this.filterDefinition;
    }

    public String getName() {
        return this.filterDefinition.getFilterName();
    }

    public Filter setParameter(String name, Object value) {
        return this;
    }

    public Filter setParameterList(String name, Collection values) {
        return this;
    }

    public Filter setParameterList(String name, Object[] values) {
        return this;
    }

    public void validate() throws HibernateException {
    }
}

