/*
 * Copyright Openmind http://www.openmindonline.it
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package it.openutils.hibernate.security.dao.impl;

import it.openutils.dao.hibernate.HibernateDAOImpl;
import it.openutils.hibernate.security.dao.SecurityRuleDAO;
import it.openutils.hibernate.security.dataobject.SecurityRule;


/**
 * @author fcarone
 * @version $Id: SecurityRuleDAOImpl.java 705 2008-02-26 10:56:55Z fcarone $
 */
public class SecurityRuleDAOImpl extends HibernateDAOImpl<SecurityRule, Long> implements SecurityRuleDAO
{

    /**
     * {@inheritDoc}
     */
    @Override
    protected Class<SecurityRule> getReferenceClass()
    {
        return SecurityRule.class;
    }

}
