/*
 * Copyright (c) Openmind.  All rights reserved. http://www.openmindonline.it
 */
package it.openutils.hibernate.security.services.impl;

import it.openutils.hibernate.security.dao.SecurityRuleDAO;
import it.openutils.hibernate.security.dataobject.SecurityRule;
import it.openutils.hibernate.security.filter.JavaBeanFilter;
import it.openutils.hibernate.security.services.SecurityRuleManager;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Filter;


/**
 * @author fcarone
 * @version $Id: SecurityRuleManagerImpl.java 680 2008-02-21 14:57:26Z fcarone $
 */
public class SecurityRuleManagerImpl implements SecurityRuleManager
{

    private SecurityRuleDAO securityRuleDAO;

    /**
     * Sets the securityRuleDAO.
     * @param securityRuleDAO the securityRuleDAO to set
     */
    public void setSecurityRuleDAO(SecurityRuleDAO securityRuleDAO)
    {
        this.securityRuleDAO = securityRuleDAO;
    }

    /**
     * {@inheritDoc}
     */
    public List<SecurityRule> findAll()
    {
        return securityRuleDAO.findAll();
    }

    /**
     * {@inheritDoc}
     */
    public List<SecurityRule> findFiltered(SecurityRule filter)
    {
        return securityRuleDAO.findFiltered(filter);
    }

    /**
     * {@inheritDoc}
     */
    public Filter getEntityFilterFromRules(String entity, List<SecurityRule> rules) throws SecurityException,
        ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException
    {
        return new JavaBeanFilter(entity, rules);
    }

    /**
     * {@inheritDoc}
     */
    public SecurityRule load(Long id)
    {
        return securityRuleDAO.load(id);
    }

    /**
     * {@inheritDoc}
     */
    public SecurityRule loadIfAvailable(Long id)
    {
        return securityRuleDAO.loadIfAvailable(id);
    }

    /**
     * {@inheritDoc}
     */
    public boolean delete(Long id)
    {
        return securityRuleDAO.delete(id);
    }

    /**
     * {@inheritDoc}
     */
    public Long save(SecurityRule securityRule)
    {
        return securityRuleDAO.save(securityRule);
    }

    /**
     * {@inheritDoc}
     */
    public void saveOrUpdate(SecurityRule securityRule)
    {
        securityRuleDAO.saveOrUpdate(securityRule);
    }

    /**
     * {@inheritDoc}
     */
    public void update(SecurityRule securityRule)
    {
        securityRuleDAO.update(securityRule);
    }

    /**
     * {@inheritDoc}
     */
    public List<SecurityRule> getRulesForRoles(String entity, List<String> roles)
    {
        List<SecurityRule> rules = new ArrayList<SecurityRule>();
        for (String role : roles)
        {
            SecurityRule filter = new SecurityRule();
            filter.setEntity(entity);
            filter.setRole(role);
            rules.addAll(findFiltered(filter));
        }
        return rules;
    }

    /**
     * {@inheritDoc}
     */
    public List<SecurityRule> getRulesForRoles(Object entity, List<String> roles)
    {
        return findAllRules(entity, roles);
    }

    @SuppressWarnings("unchecked")
    private List<SecurityRule> findAllRules(Object object, List<String> roles)
    {
        List<SecurityRule> result = new ArrayList<SecurityRule>();

        Class objectClass = object.getClass();
        while (!objectClass.isAssignableFrom(Object.class))
        {
            result.addAll(getRulesForRoles(StringUtils.substringBefore(objectClass.getName(), "$$"), roles));

            objectClass = objectClass.getSuperclass();
        }
        return result;
    }
}
