/*
 * Copyright (c) Openmind.  All rights reserved. http://www.openmindonline.it
 */
package it.openutils.hibernate.security.filter;

import it.openutils.hibernate.security.dataobject.PermissionEnum;

import org.acegisecurity.ConfigAttribute;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * @author fcarone
 * @version $Id: SecurityRuleBaseHandler.java 672 2008-02-20 17:14:54Z fcarone $
 */
public abstract class SecurityRuleBaseHandler
{

    /**
     * Logger.
     */
    private Logger log = LoggerFactory.getLogger(SecurityRuleBaseHandler.class);

    /**
     * {@inheritDoc}
     */
    public boolean supports(ConfigAttribute attribute)
    {
        log.debug("Evaluating attribute {}", attribute.getAttribute());

        for (PermissionEnum permission : PermissionEnum.values())
        {
            if (StringUtils.equals(permission.getValue(), attribute.getAttribute()))
            {
                log.debug("Support ok.");
                return true;
            }
        }
        log.debug("Not supporting attribute.");
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("unchecked")
    public boolean supports(Class clazz)
    {
        return true;
    }

}
