/*
 * Copyright (c) Openmind.  All rights reserved. http://www.openmindonline.it
 */
package it.openutils.hibernate.security.filter;

import it.openutils.hibernate.security.services.SecurityRuleManager;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.afterinvocation.AfterInvocationProvider;
import org.apache.commons.collections.CollectionUtils;


/**
 * @author fcarone
 * @version $Id: SecurityRuleAfterInvocationHandler.java 672 2008-02-20 17:14:54Z fcarone $
 */
public class SecurityRuleAfterInvocationHandler extends SecurityRuleBaseHandler implements AfterInvocationProvider
{

    private SecurityRuleManager securityRuleManager;

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("unchecked")
    public Object decide(Authentication authentication, Object object, ConfigAttributeDefinition config,
        Object returnedObject) throws AccessDeniedException
    {
        if (returnedObject == null)
        {
            return null;
        }
        SecurityRulePredicate predicate = new SecurityRulePredicate(authentication, config, securityRuleManager);

        if (returnedObject instanceof Collection)
        {
            CollectionUtils.filter((Collection) returnedObject, predicate);
        }
        else if (returnedObject.getClass().isArray())
        {
            Object[] objectArray = (Object[]) returnedObject;
            List<Object> objectArrayList = Arrays.asList(objectArray);
            CollectionUtils.filter(objectArrayList, predicate);
        }
        else
        {
            if (!predicate.evaluate(returnedObject))
            {
                throw new AccessDeniedException("Access denied");
            }
        }
        return returnedObject;
    }

    /**
     * Sets the securityRuleManager.
     * @param securityRuleManager the securityRuleManager to set
     */
    public void setSecurityRuleManager(SecurityRuleManager securityRuleManager)
    {
        this.securityRuleManager = securityRuleManager;
    }

}
