/*
 * Copyright (c) Openmind.  All rights reserved. http://www.openmindonline.it
 */
package it.openutils.hibernate.security.dataobject;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Table;

import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * @author fcarone
 * @version $Id: SecurityRule.java 672 2008-02-20 17:14:54Z fcarone $ A security rule
 */
@Entity
@Table(name = "SECURITY_RULE")
public class SecurityRule implements Serializable
{

    /**
     * Generated serial version UID
     */
    private static final long serialVersionUID = -4820683448073404349L;

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "ID_SECURITY_RULE")
    private Long id;

    @Column(name = "ROLE", length = 64, nullable = false)
    private String role;

    @Column(name = "ENTITY", length = 512, nullable = false)
    private String entity;

    @Column(name = "PROPERTY", length = 512, nullable = false)
    private String property;

    @Column(name = "VALUE", nullable = false)
    private String value;

    @Enumerated(EnumType.STRING)
    @Column(name = "MODIFIER", nullable = false)
    private ModifierEnum modifier;

    @CollectionOfElements(fetch = FetchType.EAGER)
    @JoinTable(name = "SECRULE_PERMISSION", joinColumns = {@JoinColumn(name = "ID_SECURITY_RULE") })
    @Column(name = "PERMISSION", nullable = false)
    @Enumerated(EnumType.STRING)
    @Fetch(FetchMode.SUBSELECT)
    private List<PermissionEnum> permissions;

    /**
     * Returns the role.
     * @return the role
     */
    public String getRole()
    {
        return role;
    }

    /**
     * Sets the role.
     * @param role the role to set
     */
    public void setRole(String role)
    {
        this.role = role;
    }

    /**
     * Returns the entity.
     * @return the entity
     */
    public String getEntity()
    {
        return entity;
    }

    /**
     * Sets the entity.
     * @param entity the entity to set
     */
    public void setEntity(String entity)
    {
        this.entity = entity;
    }

    /**
     * Returns the property.
     * @return the property
     */
    public String getProperty()
    {
        return property;
    }

    /**
     * Sets the property.
     * @param property the property to set
     */
    public void setProperty(String property)
    {
        this.property = property;
    }

    /**
     * Returns the value.
     * @return the value
     */
    public String getValue()
    {
        return value;
    }

    /**
     * Sets the value.
     * @param value the value to set
     */
    public void setValue(String value)
    {
        this.value = value;
    }

    /**
     * Returns the modifier.
     * @return the modifier
     */
    public ModifierEnum getModifier()
    {
        return modifier;
    }

    /**
     * Sets the modifier.
     * @param modifier the modifier to set
     */
    public void setModifier(ModifierEnum modifier)
    {
        this.modifier = modifier;
    }

    /**
     * Returns the permissions.
     * @return the permissions
     */
    public List<PermissionEnum> getPermissions()
    {
        return permissions;
    }

    /**
     * Sets the permissions.
     * @param permissions the permissions to set
     */
    public void setPermissions(List<PermissionEnum> permissions)
    {
        this.permissions = permissions;
    }

    /**
     * Returns the id.
     * @return the id
     */
    public Long getId()
    {
        return id;
    }

    /**
     * Sets the id.
     * @param id the id to set
     */
    public void setId(Long id)
    {
        this.id = id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString()
    {
        return new ToStringBuilder(this)
            .append("id", this.id)
            .append("role", this.role)
            .append("entity", this.entity)
            .append("property", this.property)
            .append("value", this.value)
            .append("modifier", this.modifier)
            .append("permissions", this.permissions)
            .toString();
    }

}
